package zio.aws.m2
import zio.aws.m2.model.ListBatchJobDefinitionsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.m2.M2AsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.m2.model.{
  UpdateApplicationRequest,
  ListBatchJobExecutionsRequest,
  ListDataSetsRequest,
  GetApplicationVersionRequest,
  CancelBatchJobExecutionRequest,
  GetEnvironmentRequest,
  GetBatchJobExecutionRequest,
  DeleteApplicationRequest,
  ListEnvironmentsRequest,
  StartApplicationRequest,
  DeleteApplicationFromEnvironmentRequest,
  UpdateEnvironmentRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  StartBatchJobRequest,
  GetDataSetImportTaskRequest,
  ListBatchJobDefinitionsRequest,
  ListDeploymentsRequest,
  GetApplicationRequest,
  ListEngineVersionsRequest,
  UntagResourceRequest,
  ListApplicationsRequest,
  StopApplicationRequest,
  CreateDeploymentRequest,
  CreateEnvironmentRequest,
  GetDeploymentRequest,
  GetDataSetDetailsRequest,
  DeleteEnvironmentRequest,
  ListApplicationVersionsRequest,
  ListDataSetImportHistoryRequest,
  CreateDataSetImportTaskRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object M2Mock extends Mock[M2] {
  object DeleteEnvironment
      extends Effect[
        DeleteEnvironmentRequest,
        AwsError,
        zio.aws.m2.model.DeleteEnvironmentResponse.ReadOnly
      ]
  object GetApplication
      extends Effect[
        GetApplicationRequest,
        AwsError,
        zio.aws.m2.model.GetApplicationResponse.ReadOnly
      ]
  object ListBatchJobExecutions
      extends Stream[
        ListBatchJobExecutionsRequest,
        AwsError,
        zio.aws.m2.model.BatchJobExecutionSummary.ReadOnly
      ]
  object ListBatchJobExecutionsPaginated
      extends Effect[
        ListBatchJobExecutionsRequest,
        AwsError,
        zio.aws.m2.model.ListBatchJobExecutionsResponse.ReadOnly
      ]
  object DeleteApplication
      extends Effect[
        DeleteApplicationRequest,
        AwsError,
        zio.aws.m2.model.DeleteApplicationResponse.ReadOnly
      ]
  object CreateEnvironment
      extends Effect[
        CreateEnvironmentRequest,
        AwsError,
        zio.aws.m2.model.CreateEnvironmentResponse.ReadOnly
      ]
  object GetDataSetImportTask
      extends Effect[
        GetDataSetImportTaskRequest,
        AwsError,
        zio.aws.m2.model.GetDataSetImportTaskResponse.ReadOnly
      ]
  object GetEnvironment
      extends Effect[
        GetEnvironmentRequest,
        AwsError,
        zio.aws.m2.model.GetEnvironmentResponse.ReadOnly
      ]
  object ListEngineVersions
      extends Stream[
        ListEngineVersionsRequest,
        AwsError,
        zio.aws.m2.model.EngineVersionsSummary.ReadOnly
      ]
  object ListEngineVersionsPaginated
      extends Effect[
        ListEngineVersionsRequest,
        AwsError,
        zio.aws.m2.model.ListEngineVersionsResponse.ReadOnly
      ]
  object GetDeployment
      extends Effect[
        GetDeploymentRequest,
        AwsError,
        zio.aws.m2.model.GetDeploymentResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.m2.model.CreateApplicationResponse.ReadOnly
      ]
  object CancelBatchJobExecution
      extends Effect[
        CancelBatchJobExecutionRequest,
        AwsError,
        zio.aws.m2.model.CancelBatchJobExecutionResponse.ReadOnly
      ]
  object ListDataSets
      extends Stream[
        ListDataSetsRequest,
        AwsError,
        zio.aws.m2.model.DataSetSummary.ReadOnly
      ]
  object ListDataSetsPaginated
      extends Effect[
        ListDataSetsRequest,
        AwsError,
        zio.aws.m2.model.ListDataSetsResponse.ReadOnly
      ]
  object GetBatchJobExecution
      extends Effect[
        GetBatchJobExecutionRequest,
        AwsError,
        zio.aws.m2.model.GetBatchJobExecutionResponse.ReadOnly
      ]
  object GetApplicationVersion
      extends Effect[
        GetApplicationVersionRequest,
        AwsError,
        zio.aws.m2.model.GetApplicationVersionResponse.ReadOnly
      ]
  object DeleteApplicationFromEnvironment
      extends Effect[
        DeleteApplicationFromEnvironmentRequest,
        AwsError,
        zio.aws.m2.model.DeleteApplicationFromEnvironmentResponse.ReadOnly
      ]
  object ListDeployments
      extends Stream[
        ListDeploymentsRequest,
        AwsError,
        zio.aws.m2.model.DeploymentSummary.ReadOnly
      ]
  object ListDeploymentsPaginated
      extends Effect[
        ListDeploymentsRequest,
        AwsError,
        zio.aws.m2.model.ListDeploymentsResponse.ReadOnly
      ]
  object StartApplication
      extends Effect[
        StartApplicationRequest,
        AwsError,
        zio.aws.m2.model.StartApplicationResponse.ReadOnly
      ]
  object StartBatchJob
      extends Effect[
        StartBatchJobRequest,
        AwsError,
        zio.aws.m2.model.StartBatchJobResponse.ReadOnly
      ]
  object ListEnvironments
      extends Stream[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.m2.model.EnvironmentSummary.ReadOnly
      ]
  object ListEnvironmentsPaginated
      extends Effect[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.m2.model.ListEnvironmentsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.m2.model.UntagResourceResponse.ReadOnly
      ]
  object CreateDeployment
      extends Effect[
        CreateDeploymentRequest,
        AwsError,
        zio.aws.m2.model.CreateDeploymentResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.m2.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.m2.model.TagResourceResponse.ReadOnly
      ]
  object ListApplications
      extends Stream[
        ListApplicationsRequest,
        AwsError,
        zio.aws.m2.model.ApplicationSummary.ReadOnly
      ]
  object ListApplicationsPaginated
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.m2.model.ListApplicationsResponse.ReadOnly
      ]
  object ListDataSetImportHistory
      extends Stream[
        ListDataSetImportHistoryRequest,
        AwsError,
        zio.aws.m2.model.DataSetImportTask.ReadOnly
      ]
  object ListDataSetImportHistoryPaginated
      extends Effect[
        ListDataSetImportHistoryRequest,
        AwsError,
        zio.aws.m2.model.ListDataSetImportHistoryResponse.ReadOnly
      ]
  object UpdateEnvironment
      extends Effect[
        UpdateEnvironmentRequest,
        AwsError,
        zio.aws.m2.model.UpdateEnvironmentResponse.ReadOnly
      ]
  object GetDataSetDetails
      extends Effect[
        GetDataSetDetailsRequest,
        AwsError,
        zio.aws.m2.model.GetDataSetDetailsResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[
        UpdateApplicationRequest,
        AwsError,
        zio.aws.m2.model.UpdateApplicationResponse.ReadOnly
      ]
  object ListApplicationVersions
      extends Stream[
        ListApplicationVersionsRequest,
        AwsError,
        zio.aws.m2.model.ApplicationVersionSummary.ReadOnly
      ]
  object ListApplicationVersionsPaginated
      extends Effect[
        ListApplicationVersionsRequest,
        AwsError,
        zio.aws.m2.model.ListApplicationVersionsResponse.ReadOnly
      ]
  object CreateDataSetImportTask
      extends Effect[
        CreateDataSetImportTaskRequest,
        AwsError,
        zio.aws.m2.model.CreateDataSetImportTaskResponse.ReadOnly
      ]
  object StopApplication
      extends Effect[
        StopApplicationRequest,
        AwsError,
        zio.aws.m2.model.StopApplicationResponse.ReadOnly
      ]
  object ListBatchJobDefinitions
      extends Stream[
        ListBatchJobDefinitionsRequest,
        AwsError,
        zio.aws.m2.model.BatchJobDefinition.ReadOnly
      ]
  object ListBatchJobDefinitionsPaginated
      extends Effect[ListBatchJobDefinitionsRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, M2] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, M2] { rts =>
        zio.ZIO.succeed {
          new M2 {
            val api: M2AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): M2 = this
            def deleteEnvironment(request: DeleteEnvironmentRequest): IO[
              AwsError,
              zio.aws.m2.model.DeleteEnvironmentResponse.ReadOnly
            ] = proxy(DeleteEnvironment, request)
            def getApplication(
                request: GetApplicationRequest
            ): IO[AwsError, zio.aws.m2.model.GetApplicationResponse.ReadOnly] =
              proxy(GetApplication, request)
            def listBatchJobExecutions(
                request: ListBatchJobExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.m2.model.BatchJobExecutionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListBatchJobExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listBatchJobExecutionsPaginated(
                request: ListBatchJobExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.m2.model.ListBatchJobExecutionsResponse.ReadOnly
            ] = proxy(ListBatchJobExecutionsPaginated, request)
            def deleteApplication(request: DeleteApplicationRequest): IO[
              AwsError,
              zio.aws.m2.model.DeleteApplicationResponse.ReadOnly
            ] = proxy(DeleteApplication, request)
            def createEnvironment(request: CreateEnvironmentRequest): IO[
              AwsError,
              zio.aws.m2.model.CreateEnvironmentResponse.ReadOnly
            ] = proxy(CreateEnvironment, request)
            def getDataSetImportTask(request: GetDataSetImportTaskRequest): IO[
              AwsError,
              zio.aws.m2.model.GetDataSetImportTaskResponse.ReadOnly
            ] = proxy(GetDataSetImportTask, request)
            def getEnvironment(
                request: GetEnvironmentRequest
            ): IO[AwsError, zio.aws.m2.model.GetEnvironmentResponse.ReadOnly] =
              proxy(GetEnvironment, request)
            def listEngineVersions(request: ListEngineVersionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.m2.model.EngineVersionsSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEngineVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEngineVersionsPaginated(
                request: ListEngineVersionsRequest
            ): IO[
              AwsError,
              zio.aws.m2.model.ListEngineVersionsResponse.ReadOnly
            ] = proxy(ListEngineVersionsPaginated, request)
            def getDeployment(
                request: GetDeploymentRequest
            ): IO[AwsError, zio.aws.m2.model.GetDeploymentResponse.ReadOnly] =
              proxy(GetDeployment, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.m2.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def cancelBatchJobExecution(
                request: CancelBatchJobExecutionRequest
            ): IO[
              AwsError,
              zio.aws.m2.model.CancelBatchJobExecutionResponse.ReadOnly
            ] = proxy(CancelBatchJobExecution, request)
            def listDataSets(request: ListDataSetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.m2.model.DataSetSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataSets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataSetsPaginated(
                request: ListDataSetsRequest
            ): IO[AwsError, zio.aws.m2.model.ListDataSetsResponse.ReadOnly] =
              proxy(ListDataSetsPaginated, request)
            def getBatchJobExecution(request: GetBatchJobExecutionRequest): IO[
              AwsError,
              zio.aws.m2.model.GetBatchJobExecutionResponse.ReadOnly
            ] = proxy(GetBatchJobExecution, request)
            def getApplicationVersion(
                request: GetApplicationVersionRequest
            ): IO[
              AwsError,
              zio.aws.m2.model.GetApplicationVersionResponse.ReadOnly
            ] = proxy(GetApplicationVersion, request)
            def deleteApplicationFromEnvironment(
                request: DeleteApplicationFromEnvironmentRequest
            ): IO[
              AwsError,
              zio.aws.m2.model.DeleteApplicationFromEnvironmentResponse.ReadOnly
            ] = proxy(DeleteApplicationFromEnvironment, request)
            def listDeployments(request: ListDeploymentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.m2.model.DeploymentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDeployments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDeploymentsPaginated(
                request: ListDeploymentsRequest
            ): IO[AwsError, zio.aws.m2.model.ListDeploymentsResponse.ReadOnly] =
              proxy(ListDeploymentsPaginated, request)
            def startApplication(request: StartApplicationRequest): IO[
              AwsError,
              zio.aws.m2.model.StartApplicationResponse.ReadOnly
            ] = proxy(StartApplication, request)
            def startBatchJob(
                request: StartBatchJobRequest
            ): IO[AwsError, zio.aws.m2.model.StartBatchJobResponse.ReadOnly] =
              proxy(StartBatchJob, request)
            def listEnvironments(request: ListEnvironmentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.m2.model.EnvironmentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEnvironments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEnvironmentsPaginated(request: ListEnvironmentsRequest): IO[
              AwsError,
              zio.aws.m2.model.ListEnvironmentsResponse.ReadOnly
            ] = proxy(ListEnvironmentsPaginated, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.m2.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def createDeployment(request: CreateDeploymentRequest): IO[
              AwsError,
              zio.aws.m2.model.CreateDeploymentResponse.ReadOnly
            ] = proxy(CreateDeployment, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.m2.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.m2.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def listApplications(request: ListApplicationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.m2.model.ApplicationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationsPaginated(request: ListApplicationsRequest): IO[
              AwsError,
              zio.aws.m2.model.ListApplicationsResponse.ReadOnly
            ] = proxy(ListApplicationsPaginated, request)
            def listDataSetImportHistory(
                request: ListDataSetImportHistoryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.m2.model.DataSetImportTask.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataSetImportHistory, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataSetImportHistoryPaginated(
                request: ListDataSetImportHistoryRequest
            ): IO[
              AwsError,
              zio.aws.m2.model.ListDataSetImportHistoryResponse.ReadOnly
            ] = proxy(ListDataSetImportHistoryPaginated, request)
            def updateEnvironment(request: UpdateEnvironmentRequest): IO[
              AwsError,
              zio.aws.m2.model.UpdateEnvironmentResponse.ReadOnly
            ] = proxy(UpdateEnvironment, request)
            def getDataSetDetails(request: GetDataSetDetailsRequest): IO[
              AwsError,
              zio.aws.m2.model.GetDataSetDetailsResponse.ReadOnly
            ] = proxy(GetDataSetDetails, request)
            def updateApplication(request: UpdateApplicationRequest): IO[
              AwsError,
              zio.aws.m2.model.UpdateApplicationResponse.ReadOnly
            ] = proxy(UpdateApplication, request)
            def listApplicationVersions(
                request: ListApplicationVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.m2.model.ApplicationVersionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplicationVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationVersionsPaginated(
                request: ListApplicationVersionsRequest
            ): IO[
              AwsError,
              zio.aws.m2.model.ListApplicationVersionsResponse.ReadOnly
            ] = proxy(ListApplicationVersionsPaginated, request)
            def createDataSetImportTask(
                request: CreateDataSetImportTaskRequest
            ): IO[
              AwsError,
              zio.aws.m2.model.CreateDataSetImportTaskResponse.ReadOnly
            ] = proxy(CreateDataSetImportTask, request)
            def stopApplication(
                request: StopApplicationRequest
            ): IO[AwsError, zio.aws.m2.model.StopApplicationResponse.ReadOnly] =
              proxy(StopApplication, request)
            def listBatchJobDefinitions(
                request: ListBatchJobDefinitionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.m2.model.BatchJobDefinition.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListBatchJobDefinitions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listBatchJobDefinitionsPaginated(
                request: ListBatchJobDefinitionsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListBatchJobDefinitionsPaginated, request)
          }
        }
      }
    }
  }
}
