package zio.aws.m2
import zio.prelude.Subtype
import zio.aws.m2.model.primitives.{
  Identifier,
  BatchParamKey,
  TagValue,
  String20,
  Arn,
  Integer,
  BatchParamValue,
  String50,
  EntityName,
  TagKey
}
import java.time.Instant
import zio.aws.m2.model.primitives.StringFree65000.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.m2.model.primitives.Arn.Type
    object BatchParamKey extends Subtype[String]
    type BatchParamKey = zio.aws.m2.model.primitives.BatchParamKey.Type
    object BatchParamValue extends Subtype[String]
    type BatchParamValue = zio.aws.m2.model.primitives.BatchParamValue.Type
    object CapacityValue extends Subtype[Int]
    type CapacityValue = zio.aws.m2.model.primitives.CapacityValue.Type
    object EngineVersion extends Subtype[String]
    type EngineVersion = zio.aws.m2.model.primitives.EngineVersion.Type
    object EntityDescription extends Subtype[String]
    type EntityDescription = zio.aws.m2.model.primitives.EntityDescription.Type
    object EntityName extends Subtype[String]
    type EntityName = zio.aws.m2.model.primitives.EntityName.Type
    object Identifier extends Subtype[String]
    type Identifier = zio.aws.m2.model.primitives.Identifier.Type
    type Integer = Int
    object LogGroupIdentifier extends Subtype[String]
    type LogGroupIdentifier =
      zio.aws.m2.model.primitives.LogGroupIdentifier.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.m2.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.m2.model.primitives.NextToken.Type
    object String100 extends Subtype[String]
    type String100 = zio.aws.m2.model.primitives.String100.Type
    object String20 extends Subtype[String]
    type String20 = zio.aws.m2.model.primitives.String20.Type
    object String200 extends Subtype[String]
    type String200 = zio.aws.m2.model.primitives.String200.Type
    object String2000 extends Subtype[String]
    type String2000 = zio.aws.m2.model.primitives.String2000.Type
    object String50 extends Subtype[String]
    type String50 = zio.aws.m2.model.primitives.String50.Type
    object StringFree65000 extends Subtype[String]
    type StringFree65000 = zio.aws.m2.model.primitives.StringFree65000.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.m2.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.m2.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.m2.model.primitives.Timestamp.Type
    object Version extends Subtype[Int]
    type Version = zio.aws.m2.model.primitives.Version.Type
  }
  type AlternateKeyList = List[zio.aws.m2.model.AlternateKey]
  type ApplicationSummaryList = List[zio.aws.m2.model.ApplicationSummary]
  type ApplicationVersionSummaryList =
    List[zio.aws.m2.model.ApplicationVersionSummary]
  type ArnList = List[Arn]
  type BatchJobDefinitions = List[zio.aws.m2.model.BatchJobDefinition]
  type BatchJobExecutionSummaryList =
    List[zio.aws.m2.model.BatchJobExecutionSummary]
  type BatchJobParametersMap = Map[BatchParamKey, BatchParamValue]
  type DataSetImportList = List[zio.aws.m2.model.DataSetImportItem]
  type DataSetImportTaskList = List[zio.aws.m2.model.DataSetImportTask]
  type DataSetsSummaryList = List[zio.aws.m2.model.DataSetSummary]
  type DeploymentList = List[zio.aws.m2.model.DeploymentSummary]
  type EngineVersionsSummaryList = List[zio.aws.m2.model.EngineVersionsSummary]
  type EntityNameList = List[EntityName]
  type EnvironmentSummaryList = List[zio.aws.m2.model.EnvironmentSummary]
  type IdentifierList = List[Identifier]
  type LogGroupSummaries = List[zio.aws.m2.model.LogGroupSummary]
  type PortList = List[Integer]
  type StorageConfigurationList = List[zio.aws.m2.model.StorageConfiguration]
  type String20List = List[String20]
  type String50List = List[String50]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
