package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class StopApplicationRequest(
    applicationId: Identifier,
    forceStop: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.StopApplicationRequest = {
    import StopApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.StopApplicationRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .optionallyWith(forceStop.map(value => value: java.lang.Boolean))(
        _.forceStop
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.StopApplicationRequest.ReadOnly =
    zio.aws.m2.model.StopApplicationRequest.wrap(buildAwsValue())
}
object StopApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.StopApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.StopApplicationRequest = zio.aws.m2.model
      .StopApplicationRequest(applicationId, forceStop.map(value => value))
    def applicationId: Identifier
    def forceStop: Optional[Boolean]
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getForceStop: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceStop", forceStop)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.StopApplicationRequest
  ) extends zio.aws.m2.model.StopApplicationRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val forceStop: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceStop())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.StopApplicationRequest
  ): zio.aws.m2.model.StopApplicationRequest.ReadOnly = new Wrapper(impl)
}
