package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class StartBatchJobResponse(executionId: Identifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.StartBatchJobResponse = {
    import StartBatchJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.StartBatchJobResponse
      .builder()
      .executionId(Identifier.unwrap(executionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.StartBatchJobResponse.ReadOnly =
    zio.aws.m2.model.StartBatchJobResponse.wrap(buildAwsValue())
}
object StartBatchJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.StartBatchJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.StartBatchJobResponse =
      zio.aws.m2.model.StartBatchJobResponse(executionId)
    def executionId: Identifier
    def getExecutionId: ZIO[Any, Nothing, Identifier] = ZIO.succeed(executionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.StartBatchJobResponse
  ) extends zio.aws.m2.model.StartBatchJobResponse.ReadOnly {
    override val executionId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.executionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.StartBatchJobResponse
  ): zio.aws.m2.model.StartBatchJobResponse.ReadOnly = new Wrapper(impl)
}
