package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListDataSetImportHistoryResponse(
    dataSetImportTasks: Iterable[zio.aws.m2.model.DataSetImportTask],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse = {
    import ListDataSetImportHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse
      .builder()
      .dataSetImportTasks(dataSetImportTasks.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListDataSetImportHistoryResponse.ReadOnly =
    zio.aws.m2.model.ListDataSetImportHistoryResponse.wrap(buildAwsValue())
}
object ListDataSetImportHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListDataSetImportHistoryResponse =
      zio.aws.m2.model.ListDataSetImportHistoryResponse(
        dataSetImportTasks.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def dataSetImportTasks: List[zio.aws.m2.model.DataSetImportTask.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDataSetImportTasks
        : ZIO[Any, Nothing, List[zio.aws.m2.model.DataSetImportTask.ReadOnly]] =
      ZIO.succeed(dataSetImportTasks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse
  ) extends zio.aws.m2.model.ListDataSetImportHistoryResponse.ReadOnly {
    override val dataSetImportTasks
        : List[zio.aws.m2.model.DataSetImportTask.ReadOnly] = impl
      .dataSetImportTasks()
      .asScala
      .map { item =>
        zio.aws.m2.model.DataSetImportTask.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse
  ): zio.aws.m2.model.ListDataSetImportHistoryResponse.ReadOnly = new Wrapper(
    impl
  )
}
