package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class GetDataSetImportTaskResponse(
    status: zio.aws.m2.model.DataSetTaskLifecycle,
    summary: Optional[zio.aws.m2.model.DataSetImportSummary] = Optional.Absent,
    taskId: Identifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetDataSetImportTaskResponse = {
    import GetDataSetImportTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetDataSetImportTaskResponse
      .builder()
      .status(status.unwrap)
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .taskId(Identifier.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetDataSetImportTaskResponse.ReadOnly =
    zio.aws.m2.model.GetDataSetImportTaskResponse.wrap(buildAwsValue())
}
object GetDataSetImportTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetDataSetImportTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetDataSetImportTaskResponse =
      zio.aws.m2.model.GetDataSetImportTaskResponse(
        status,
        summary.map(value => value.asEditable),
        taskId
      )
    def status: zio.aws.m2.model.DataSetTaskLifecycle
    def summary: Optional[zio.aws.m2.model.DataSetImportSummary.ReadOnly]
    def taskId: Identifier
    def getStatus: ZIO[Any, Nothing, zio.aws.m2.model.DataSetTaskLifecycle] =
      ZIO.succeed(status)
    def getSummary
        : ZIO[Any, AwsError, zio.aws.m2.model.DataSetImportSummary.ReadOnly] =
      AwsError.unwrapOptionField("summary", summary)
    def getTaskId: ZIO[Any, Nothing, Identifier] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetDataSetImportTaskResponse
  ) extends zio.aws.m2.model.GetDataSetImportTaskResponse.ReadOnly {
    override val status: zio.aws.m2.model.DataSetTaskLifecycle =
      zio.aws.m2.model.DataSetTaskLifecycle.wrap(impl.status())
    override val summary
        : Optional[zio.aws.m2.model.DataSetImportSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summary())
        .map(value => zio.aws.m2.model.DataSetImportSummary.wrap(value))
    override val taskId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetDataSetImportTaskResponse
  ): zio.aws.m2.model.GetDataSetImportTaskResponse.ReadOnly = new Wrapper(impl)
}
