package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.{String50, Integer}
import scala.jdk.CollectionConverters._
final case class GdgDetailAttributes(
    limit: Optional[Integer] = Optional.Absent,
    rollDisposition: Optional[String50] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GdgDetailAttributes = {
    import GdgDetailAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GdgDetailAttributes
      .builder()
      .optionallyWith(limit.map(value => value: java.lang.Integer))(_.limit)
      .optionallyWith(
        rollDisposition.map(value => String50.unwrap(value): java.lang.String)
      )(_.rollDisposition)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GdgDetailAttributes.ReadOnly =
    zio.aws.m2.model.GdgDetailAttributes.wrap(buildAwsValue())
}
object GdgDetailAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GdgDetailAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GdgDetailAttributes =
      zio.aws.m2.model.GdgDetailAttributes(
        limit.map(value => value),
        rollDisposition.map(value => value)
      )
    def limit: Optional[Integer]
    def rollDisposition: Optional[String50]
    def getLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("limit", limit)
    def getRollDisposition: ZIO[Any, AwsError, String50] =
      AwsError.unwrapOptionField("rollDisposition", rollDisposition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GdgDetailAttributes
  ) extends zio.aws.m2.model.GdgDetailAttributes.ReadOnly {
    override val limit: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: Integer)
    override val rollDisposition: Optional[String50] = zio.aws.core.internal
      .optionalFromNullable(impl.rollDisposition())
      .map(value => zio.aws.m2.model.primitives.String50(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GdgDetailAttributes
  ): zio.aws.m2.model.GdgDetailAttributes.ReadOnly = new Wrapper(impl)
}
