package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.{Timestamp, Version, Identifier}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DeploymentSummary(
    applicationId: Identifier,
    applicationVersion: Version,
    creationTime: Timestamp,
    deploymentId: Identifier,
    environmentId: Identifier,
    status: zio.aws.m2.model.DeploymentLifecycle,
    statusReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DeploymentSummary = {
    import DeploymentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DeploymentSummary
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .applicationVersion(Version.unwrap(applicationVersion): Integer)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .deploymentId(Identifier.unwrap(deploymentId): java.lang.String)
      .environmentId(Identifier.unwrap(environmentId): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DeploymentSummary.ReadOnly =
    zio.aws.m2.model.DeploymentSummary.wrap(buildAwsValue())
}
object DeploymentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.DeploymentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DeploymentSummary =
      zio.aws.m2.model.DeploymentSummary(
        applicationId,
        applicationVersion,
        creationTime,
        deploymentId,
        environmentId,
        status,
        statusReason.map(value => value)
      )
    def applicationId: Identifier
    def applicationVersion: Version
    def creationTime: Timestamp
    def deploymentId: Identifier
    def environmentId: Identifier
    def status: zio.aws.m2.model.DeploymentLifecycle
    def statusReason: Optional[String]
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getApplicationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(applicationVersion)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getDeploymentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(deploymentId)
    def getEnvironmentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(environmentId)
    def getStatus: ZIO[Any, Nothing, zio.aws.m2.model.DeploymentLifecycle] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DeploymentSummary
  ) extends zio.aws.m2.model.DeploymentSummary.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val applicationVersion: Version =
      zio.aws.m2.model.primitives.Version(impl.applicationVersion())
    override val creationTime: Timestamp =
      zio.aws.m2.model.primitives.Timestamp(impl.creationTime())
    override val deploymentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.deploymentId())
    override val environmentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.environmentId())
    override val status: zio.aws.m2.model.DeploymentLifecycle =
      zio.aws.m2.model.DeploymentLifecycle.wrap(impl.status())
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DeploymentSummary
  ): zio.aws.m2.model.DeploymentSummary.ReadOnly = new Wrapper(impl)
}
