package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentRequest(environmentId: Identifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DeleteEnvironmentRequest = {
    import DeleteEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DeleteEnvironmentRequest
      .builder()
      .environmentId(Identifier.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DeleteEnvironmentRequest.ReadOnly =
    zio.aws.m2.model.DeleteEnvironmentRequest.wrap(buildAwsValue())
}
object DeleteEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.DeleteEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DeleteEnvironmentRequest =
      zio.aws.m2.model.DeleteEnvironmentRequest(environmentId)
    def environmentId: Identifier
    def getEnvironmentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DeleteEnvironmentRequest
  ) extends zio.aws.m2.model.DeleteEnvironmentRequest.ReadOnly {
    override val environmentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DeleteEnvironmentRequest
  ): zio.aws.m2.model.DeleteEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
