package zio.aws.m2.model
import scala.jdk.CollectionConverters._
sealed trait BatchJobExecutionStatus {
  def unwrap: software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus
}
object BatchJobExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus
  ): zio.aws.m2.model.BatchJobExecutionStatus = value match {
    case software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.SUBMITTING =>
      val r = Submitting
      r
    case software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.HOLDING =>
      val r = Holding
      r
    case software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.DISPATCHING =>
      val r = Dispatching
      r
    case software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.RUNNING =>
      val r = Running
      r
    case software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.CANCELLING =>
      val r = Cancelling
      r
    case software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.SUCCEEDED_WITH_WARNING =>
      val r = `Succeeded With Warning`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.m2.model.BatchJobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus =
      software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Submitting extends zio.aws.m2.model.BatchJobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus =
      software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.SUBMITTING
  }
  case object Holding extends zio.aws.m2.model.BatchJobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus =
      software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.HOLDING
  }
  case object Dispatching extends zio.aws.m2.model.BatchJobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus =
      software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.DISPATCHING
  }
  case object Running extends zio.aws.m2.model.BatchJobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus =
      software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.RUNNING
  }
  case object Cancelling extends zio.aws.m2.model.BatchJobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus =
      software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.CANCELLING
  }
  case object Cancelled extends zio.aws.m2.model.BatchJobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus =
      software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.CANCELLED
  }
  case object Succeeded extends zio.aws.m2.model.BatchJobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus =
      software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.SUCCEEDED
  }
  case object Failed extends zio.aws.m2.model.BatchJobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus =
      software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.FAILED
  }
  case object `Succeeded With Warning`
      extends zio.aws.m2.model.BatchJobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus =
      software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus.SUCCEEDED_WITH_WARNING
  }
}
