package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.{BatchParamValue, BatchParamKey, Identifier}
import scala.jdk.CollectionConverters._
final case class StartBatchJobRequest(
    applicationId: Identifier,
    batchJobIdentifier: zio.aws.m2.model.BatchJobIdentifier,
    jobParams: Optional[Map[BatchParamKey, BatchParamValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.StartBatchJobRequest = {
    import StartBatchJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.StartBatchJobRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .batchJobIdentifier(batchJobIdentifier.buildAwsValue())
      .optionallyWith(
        jobParams.map(value =>
          value
            .map({ case (key, value) =>
              (BatchParamKey.unwrap(key): java.lang.String) -> (BatchParamValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.jobParams)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.StartBatchJobRequest.ReadOnly =
    zio.aws.m2.model.StartBatchJobRequest.wrap(buildAwsValue())
}
object StartBatchJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.StartBatchJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.StartBatchJobRequest =
      zio.aws.m2.model.StartBatchJobRequest(
        applicationId,
        batchJobIdentifier.asEditable,
        jobParams.map(value => value)
      )
    def applicationId: Identifier
    def batchJobIdentifier: zio.aws.m2.model.BatchJobIdentifier.ReadOnly
    def jobParams: Optional[Map[BatchParamKey, BatchParamValue]]
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getBatchJobIdentifier
        : ZIO[Any, Nothing, zio.aws.m2.model.BatchJobIdentifier.ReadOnly] =
      ZIO.succeed(batchJobIdentifier)
    def getJobParams: ZIO[Any, AwsError, Map[BatchParamKey, BatchParamValue]] =
      AwsError.unwrapOptionField("jobParams", jobParams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.StartBatchJobRequest
  ) extends zio.aws.m2.model.StartBatchJobRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val batchJobIdentifier
        : zio.aws.m2.model.BatchJobIdentifier.ReadOnly =
      zio.aws.m2.model.BatchJobIdentifier.wrap(impl.batchJobIdentifier())
    override val jobParams: Optional[Map[BatchParamKey, BatchParamValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobParams())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.m2.model.primitives.BatchParamKey(
                key
              ) -> zio.aws.m2.model.primitives.BatchParamValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.StartBatchJobRequest
  ): zio.aws.m2.model.StartBatchJobRequest.ReadOnly = new Wrapper(impl)
}
