package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class PrimaryKey(
    length: Integer,
    name: Optional[String] = Optional.Absent,
    offset: Integer
) {
  def buildAwsValue(): software.amazon.awssdk.services.m2.model.PrimaryKey = {
    import PrimaryKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.PrimaryKey
      .builder()
      .length(length: java.lang.Integer)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .offset(offset: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.PrimaryKey.ReadOnly =
    zio.aws.m2.model.PrimaryKey.wrap(buildAwsValue())
}
object PrimaryKey {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.m2.model.PrimaryKey] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.PrimaryKey =
      zio.aws.m2.model.PrimaryKey(length, name.map(value => value), offset)
    def length: Integer
    def name: Optional[String]
    def offset: Integer
    def getLength: ZIO[Any, Nothing, Integer] = ZIO.succeed(length)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getOffset: ZIO[Any, Nothing, Integer] = ZIO.succeed(offset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.PrimaryKey
  ) extends zio.aws.m2.model.PrimaryKey.ReadOnly {
    override val length: Integer = impl.length(): Integer
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val offset: Integer = impl.offset(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.PrimaryKey
  ): zio.aws.m2.model.PrimaryKey.ReadOnly = new Wrapper(impl)
}
