package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.String20
import scala.jdk.CollectionConverters._
final case class PoAttributes(
    encoding: Optional[String] = Optional.Absent,
    format: String,
    memberFileExtensions: Iterable[String20]
) {
  def buildAwsValue(): software.amazon.awssdk.services.m2.model.PoAttributes = {
    import PoAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.PoAttributes
      .builder()
      .optionallyWith(encoding.map(value => value: java.lang.String))(
        _.encoding
      )
      .format(format: java.lang.String)
      .memberFileExtensions(memberFileExtensions.map { item =>
        String20.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.PoAttributes.ReadOnly =
    zio.aws.m2.model.PoAttributes.wrap(buildAwsValue())
}
object PoAttributes {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.m2.model.PoAttributes] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.PoAttributes = zio.aws.m2.model
      .PoAttributes(encoding.map(value => value), format, memberFileExtensions)
    def encoding: Optional[String]
    def format: String
    def memberFileExtensions: List[String20]
    def getEncoding: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encoding", encoding)
    def getFormat: ZIO[Any, Nothing, String] = ZIO.succeed(format)
    def getMemberFileExtensions: ZIO[Any, Nothing, List[String20]] =
      ZIO.succeed(memberFileExtensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.PoAttributes
  ) extends zio.aws.m2.model.PoAttributes.ReadOnly {
    override val encoding: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.encoding())
      .map(value => value: String)
    override val format: String = impl.format(): String
    override val memberFileExtensions: List[String20] = impl
      .memberFileExtensions()
      .asScala
      .map { item =>
        zio.aws.m2.model.primitives.String20(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.PoAttributes
  ): zio.aws.m2.model.PoAttributes.ReadOnly = new Wrapper(impl)
}
