package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.{String20, LogGroupIdentifier}
import scala.jdk.CollectionConverters._
final case class LogGroupSummary(
    logGroupName: LogGroupIdentifier,
    logType: String20
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.LogGroupSummary = {
    import LogGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.LogGroupSummary
      .builder()
      .logGroupName(LogGroupIdentifier.unwrap(logGroupName): java.lang.String)
      .logType(String20.unwrap(logType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.LogGroupSummary.ReadOnly =
    zio.aws.m2.model.LogGroupSummary.wrap(buildAwsValue())
}
object LogGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.LogGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.LogGroupSummary =
      zio.aws.m2.model.LogGroupSummary(logGroupName, logType)
    def logGroupName: LogGroupIdentifier
    def logType: String20
    def getLogGroupName: ZIO[Any, Nothing, LogGroupIdentifier] =
      ZIO.succeed(logGroupName)
    def getLogType: ZIO[Any, Nothing, String20] = ZIO.succeed(logType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.LogGroupSummary
  ) extends zio.aws.m2.model.LogGroupSummary.ReadOnly {
    override val logGroupName: LogGroupIdentifier =
      zio.aws.m2.model.primitives.LogGroupIdentifier(impl.logGroupName())
    override val logType: String20 =
      zio.aws.m2.model.primitives.String20(impl.logType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.LogGroupSummary
  ): zio.aws.m2.model.LogGroupSummary.ReadOnly = new Wrapper(impl)
}
