package zio.aws.m2.model
import zio.aws.m2.model.primitives.{
  String200,
  NextToken,
  MaxResults,
  Identifier
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDataSetsRequest(
    applicationId: Identifier,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    prefix: Optional[String200] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListDataSetsRequest = {
    import ListDataSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListDataSetsRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        prefix.map(value => String200.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListDataSetsRequest.ReadOnly =
    zio.aws.m2.model.ListDataSetsRequest.wrap(buildAwsValue())
}
object ListDataSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListDataSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListDataSetsRequest =
      zio.aws.m2.model.ListDataSetsRequest(
        applicationId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        prefix.map(value => value)
      )
    def applicationId: Identifier
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def prefix: Optional[String200]
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrefix: ZIO[Any, AwsError, String200] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListDataSetsRequest
  ) extends zio.aws.m2.model.ListDataSetsRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.m2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
    override val prefix: Optional[String200] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.m2.model.primitives.String200(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListDataSetsRequest
  ): zio.aws.m2.model.ListDataSetsRequest.ReadOnly = new Wrapper(impl)
}
