package zio.aws.m2.model
import zio.aws.m2.model.primitives.{NextToken, MaxResults, Identifier}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDataSetImportHistoryRequest(
    applicationId: Identifier,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest = {
    import ListDataSetImportHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListDataSetImportHistoryRequest.ReadOnly =
    zio.aws.m2.model.ListDataSetImportHistoryRequest.wrap(buildAwsValue())
}
object ListDataSetImportHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListDataSetImportHistoryRequest =
      zio.aws.m2.model.ListDataSetImportHistoryRequest(
        applicationId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def applicationId: Identifier
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest
  ) extends zio.aws.m2.model.ListDataSetImportHistoryRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.m2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest
  ): zio.aws.m2.model.ListDataSetImportHistoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
