package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.{
  String100,
  Identifier,
  Timestamp,
  TagValue,
  Arn,
  Integer,
  EntityDescription,
  EntityName,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetApplicationResponse(
    applicationArn: Arn,
    applicationId: Identifier,
    creationTime: Timestamp,
    deployedVersion: Optional[zio.aws.m2.model.DeployedVersionSummary] =
      Optional.Absent,
    description: Optional[EntityDescription] = Optional.Absent,
    engineType: zio.aws.m2.model.EngineType,
    environmentId: Optional[Identifier] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    lastStartTime: Optional[Timestamp] = Optional.Absent,
    latestVersion: zio.aws.m2.model.ApplicationVersionSummary,
    listenerArns: Optional[Iterable[Arn]] = Optional.Absent,
    listenerPorts: Optional[Iterable[Integer]] = Optional.Absent,
    loadBalancerDnsName: Optional[String100] = Optional.Absent,
    logGroups: Optional[Iterable[zio.aws.m2.model.LogGroupSummary]] =
      Optional.Absent,
    name: EntityName,
    roleArn: Optional[Arn] = Optional.Absent,
    status: zio.aws.m2.model.ApplicationLifecycle,
    statusReason: Optional[String] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    targetGroupArns: Optional[Iterable[Arn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetApplicationResponse = {
    import GetApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetApplicationResponse
      .builder()
      .applicationArn(Arn.unwrap(applicationArn): java.lang.String)
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(deployedVersion.map(value => value.buildAwsValue()))(
        _.deployedVersion
      )
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .engineType(engineType.unwrap)
      .optionallyWith(
        environmentId.map(value => Identifier.unwrap(value): java.lang.String)
      )(_.environmentId)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        lastStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStartTime)
      .latestVersion(latestVersion.buildAwsValue())
      .optionallyWith(
        listenerArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.listenerArns)
      .optionallyWith(
        listenerPorts.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.listenerPorts)
      .optionallyWith(
        loadBalancerDnsName.map(value =>
          String100.unwrap(value): java.lang.String
        )
      )(_.loadBalancerDnsName)
      .optionallyWith(
        logGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logGroups)
      .name(EntityName.unwrap(name): java.lang.String)
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        targetGroupArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetGroupArns)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetApplicationResponse.ReadOnly =
    zio.aws.m2.model.GetApplicationResponse.wrap(buildAwsValue())
}
object GetApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetApplicationResponse =
      zio.aws.m2.model.GetApplicationResponse(
        applicationArn,
        applicationId,
        creationTime,
        deployedVersion.map(value => value.asEditable),
        description.map(value => value),
        engineType,
        environmentId.map(value => value),
        kmsKeyId.map(value => value),
        lastStartTime.map(value => value),
        latestVersion.asEditable,
        listenerArns.map(value => value),
        listenerPorts.map(value => value),
        loadBalancerDnsName.map(value => value),
        logGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name,
        roleArn.map(value => value),
        status,
        statusReason.map(value => value),
        tags.map(value => value),
        targetGroupArns.map(value => value)
      )
    def applicationArn: Arn
    def applicationId: Identifier
    def creationTime: Timestamp
    def deployedVersion
        : Optional[zio.aws.m2.model.DeployedVersionSummary.ReadOnly]
    def description: Optional[EntityDescription]
    def engineType: zio.aws.m2.model.EngineType
    def environmentId: Optional[Identifier]
    def kmsKeyId: Optional[String]
    def lastStartTime: Optional[Timestamp]
    def latestVersion: zio.aws.m2.model.ApplicationVersionSummary.ReadOnly
    def listenerArns: Optional[List[Arn]]
    def listenerPorts: Optional[List[Integer]]
    def loadBalancerDnsName: Optional[String100]
    def logGroups: Optional[List[zio.aws.m2.model.LogGroupSummary.ReadOnly]]
    def name: EntityName
    def roleArn: Optional[Arn]
    def status: zio.aws.m2.model.ApplicationLifecycle
    def statusReason: Optional[String]
    def tags: Optional[Map[TagKey, TagValue]]
    def targetGroupArns: Optional[List[Arn]]
    def getApplicationArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(applicationArn)
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getDeployedVersion
        : ZIO[Any, AwsError, zio.aws.m2.model.DeployedVersionSummary.ReadOnly] =
      AwsError.unwrapOptionField("deployedVersion", deployedVersion)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEngineType: ZIO[Any, Nothing, zio.aws.m2.model.EngineType] =
      ZIO.succeed(engineType)
    def getEnvironmentId: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLastStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStartTime", lastStartTime)
    def getLatestVersion: ZIO[
      Any,
      Nothing,
      zio.aws.m2.model.ApplicationVersionSummary.ReadOnly
    ] = ZIO.succeed(latestVersion)
    def getListenerArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("listenerArns", listenerArns)
    def getListenerPorts: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("listenerPorts", listenerPorts)
    def getLoadBalancerDnsName: ZIO[Any, AwsError, String100] =
      AwsError.unwrapOptionField("loadBalancerDnsName", loadBalancerDnsName)
    def getLogGroups
        : ZIO[Any, AwsError, List[zio.aws.m2.model.LogGroupSummary.ReadOnly]] =
      AwsError.unwrapOptionField("logGroups", logGroups)
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, Nothing, zio.aws.m2.model.ApplicationLifecycle] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTargetGroupArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("targetGroupArns", targetGroupArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetApplicationResponse
  ) extends zio.aws.m2.model.GetApplicationResponse.ReadOnly {
    override val applicationArn: Arn =
      zio.aws.m2.model.primitives.Arn(impl.applicationArn())
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val creationTime: Timestamp =
      zio.aws.m2.model.primitives.Timestamp(impl.creationTime())
    override val deployedVersion
        : Optional[zio.aws.m2.model.DeployedVersionSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deployedVersion())
        .map(value => zio.aws.m2.model.DeployedVersionSummary.wrap(value))
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.m2.model.primitives.EntityDescription(value))
    override val engineType: zio.aws.m2.model.EngineType =
      zio.aws.m2.model.EngineType.wrap(impl.engineType())
    override val environmentId: Optional[Identifier] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.m2.model.primitives.Identifier(value))
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val lastStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStartTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val latestVersion
        : zio.aws.m2.model.ApplicationVersionSummary.ReadOnly =
      zio.aws.m2.model.ApplicationVersionSummary.wrap(impl.latestVersion())
    override val listenerArns: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.listenerArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.m2.model.primitives.Arn(item)
        }.toList
      )
    override val listenerPorts: Optional[List[Integer]] = zio.aws.core.internal
      .optionalFromNullable(impl.listenerPorts())
      .map(value =>
        value.asScala.map { item =>
          item: Integer
        }.toList
      )
    override val loadBalancerDnsName: Optional[String100] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerDnsName())
        .map(value => zio.aws.m2.model.primitives.String100(value))
    override val logGroups
        : Optional[List[zio.aws.m2.model.LogGroupSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.m2.model.LogGroupSummary.wrap(item)
          }.toList
        )
    override val name: EntityName =
      zio.aws.m2.model.primitives.EntityName(impl.name())
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.m2.model.primitives.Arn(value))
    override val status: zio.aws.m2.model.ApplicationLifecycle =
      zio.aws.m2.model.ApplicationLifecycle.wrap(impl.status())
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.m2.model.primitives
              .TagKey(key) -> zio.aws.m2.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val targetGroupArns: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetGroupArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.m2.model.primitives.Arn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetApplicationResponse
  ): zio.aws.m2.model.GetApplicationResponse.ReadOnly = new Wrapper(impl)
}
