package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.{
  TagValue,
  Arn,
  EntityDescription,
  EntityName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateApplicationRequest(
    clientToken: Optional[String] = Optional.Absent,
    definition: zio.aws.m2.model.Definition,
    description: Optional[EntityDescription] = Optional.Absent,
    engineType: zio.aws.m2.model.EngineType,
    kmsKeyId: Optional[String] = Optional.Absent,
    name: EntityName,
    roleArn: Optional[Arn] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.CreateApplicationRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .definition(definition.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .engineType(engineType.unwrap)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .name(EntityName.unwrap(name): java.lang.String)
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.CreateApplicationRequest.ReadOnly =
    zio.aws.m2.model.CreateApplicationRequest.wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.CreateApplicationRequest =
      zio.aws.m2.model.CreateApplicationRequest(
        clientToken.map(value => value),
        definition.asEditable,
        description.map(value => value),
        engineType,
        kmsKeyId.map(value => value),
        name,
        roleArn.map(value => value),
        tags.map(value => value)
      )
    def clientToken: Optional[String]
    def definition: zio.aws.m2.model.Definition.ReadOnly
    def description: Optional[EntityDescription]
    def engineType: zio.aws.m2.model.EngineType
    def kmsKeyId: Optional[String]
    def name: EntityName
    def roleArn: Optional[Arn]
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDefinition: ZIO[Any, Nothing, zio.aws.m2.model.Definition.ReadOnly] =
      ZIO.succeed(definition)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEngineType: ZIO[Any, Nothing, zio.aws.m2.model.EngineType] =
      ZIO.succeed(engineType)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.CreateApplicationRequest
  ) extends zio.aws.m2.model.CreateApplicationRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val definition: zio.aws.m2.model.Definition.ReadOnly =
      zio.aws.m2.model.Definition.wrap(impl.definition())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.m2.model.primitives.EntityDescription(value))
    override val engineType: zio.aws.m2.model.EngineType =
      zio.aws.m2.model.EngineType.wrap(impl.engineType())
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val name: EntityName =
      zio.aws.m2.model.primitives.EntityName(impl.name())
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.m2.model.primitives.Arn(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.m2.model.primitives
              .TagKey(key) -> zio.aws.m2.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.CreateApplicationRequest
  ): zio.aws.m2.model.CreateApplicationRequest.ReadOnly = new Wrapper(impl)
}
