package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.{TagValue, TagKey, Arn}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.TagResourceRequest.ReadOnly =
    zio.aws.m2.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.TagResourceRequest =
      zio.aws.m2.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: Arn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.TagResourceRequest
  ) extends zio.aws.m2.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.m2.model.primitives.Arn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.m2.model.primitives.TagKey(key) -> zio.aws.m2.model.primitives
          .TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.TagResourceRequest
  ): zio.aws.m2.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
