package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class GetEnvironmentRequest(environmentId: Identifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetEnvironmentRequest = {
    import GetEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetEnvironmentRequest
      .builder()
      .environmentId(Identifier.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetEnvironmentRequest.ReadOnly =
    zio.aws.m2.model.GetEnvironmentRequest.wrap(buildAwsValue())
}
object GetEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetEnvironmentRequest =
      zio.aws.m2.model.GetEnvironmentRequest(environmentId)
    def environmentId: Identifier
    def getEnvironmentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetEnvironmentRequest
  ) extends zio.aws.m2.model.GetEnvironmentRequest.ReadOnly {
    override val environmentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetEnvironmentRequest
  ): zio.aws.m2.model.GetEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
