package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class GetDeploymentRequest(
    applicationId: Identifier,
    deploymentId: Identifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetDeploymentRequest = {
    import GetDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetDeploymentRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .deploymentId(Identifier.unwrap(deploymentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetDeploymentRequest.ReadOnly =
    zio.aws.m2.model.GetDeploymentRequest.wrap(buildAwsValue())
}
object GetDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetDeploymentRequest =
      zio.aws.m2.model.GetDeploymentRequest(applicationId, deploymentId)
    def applicationId: Identifier
    def deploymentId: Identifier
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getDeploymentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(deploymentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetDeploymentRequest
  ) extends zio.aws.m2.model.GetDeploymentRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val deploymentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.deploymentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetDeploymentRequest
  ): zio.aws.m2.model.GetDeploymentRequest.ReadOnly = new Wrapper(impl)
}
