package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class GdgAttributes(
    limit: Optional[Integer] = Optional.Absent,
    rollDisposition: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GdgAttributes = {
    import GdgAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GdgAttributes
      .builder()
      .optionallyWith(limit.map(value => value: java.lang.Integer))(_.limit)
      .optionallyWith(rollDisposition.map(value => value: java.lang.String))(
        _.rollDisposition
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GdgAttributes.ReadOnly =
    zio.aws.m2.model.GdgAttributes.wrap(buildAwsValue())
}
object GdgAttributes {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.m2.model.GdgAttributes] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GdgAttributes =
      zio.aws.m2.model.GdgAttributes(
        limit.map(value => value),
        rollDisposition.map(value => value)
      )
    def limit: Optional[Integer]
    def rollDisposition: Optional[String]
    def getLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("limit", limit)
    def getRollDisposition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rollDisposition", rollDisposition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GdgAttributes
  ) extends zio.aws.m2.model.GdgAttributes.ReadOnly {
    override val limit: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: Integer)
    override val rollDisposition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rollDisposition())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GdgAttributes
  ): zio.aws.m2.model.GdgAttributes.ReadOnly = new Wrapper(impl)
}
