package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FileBatchJobDefinition(
    fileName: String,
    folderPath: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.FileBatchJobDefinition = {
    import FileBatchJobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.FileBatchJobDefinition
      .builder()
      .fileName(fileName: java.lang.String)
      .optionallyWith(folderPath.map(value => value: java.lang.String))(
        _.folderPath
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.FileBatchJobDefinition.ReadOnly =
    zio.aws.m2.model.FileBatchJobDefinition.wrap(buildAwsValue())
}
object FileBatchJobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.FileBatchJobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.FileBatchJobDefinition = zio.aws.m2.model
      .FileBatchJobDefinition(fileName, folderPath.map(value => value))
    def fileName: String
    def folderPath: Optional[String]
    def getFileName: ZIO[Any, Nothing, String] = ZIO.succeed(fileName)
    def getFolderPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("folderPath", folderPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.FileBatchJobDefinition
  ) extends zio.aws.m2.model.FileBatchJobDefinition.ReadOnly {
    override val fileName: String = impl.fileName(): String
    override val folderPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.folderPath())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.FileBatchJobDefinition
  ): zio.aws.m2.model.FileBatchJobDefinition.ReadOnly = new Wrapper(impl)
}
