package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.{
  Identifier,
  Timestamp,
  String20,
  EngineVersion,
  Arn,
  EntityName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EnvironmentSummary(
    creationTime: Timestamp,
    engineType: zio.aws.m2.model.EngineType,
    engineVersion: EngineVersion,
    environmentArn: Arn,
    environmentId: Identifier,
    instanceType: String20,
    name: EntityName,
    status: zio.aws.m2.model.EnvironmentLifecycle
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.EnvironmentSummary = {
    import EnvironmentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.EnvironmentSummary
      .builder()
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .engineType(engineType.unwrap)
      .engineVersion(EngineVersion.unwrap(engineVersion): java.lang.String)
      .environmentArn(Arn.unwrap(environmentArn): java.lang.String)
      .environmentId(Identifier.unwrap(environmentId): java.lang.String)
      .instanceType(String20.unwrap(instanceType): java.lang.String)
      .name(EntityName.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.EnvironmentSummary.ReadOnly =
    zio.aws.m2.model.EnvironmentSummary.wrap(buildAwsValue())
}
object EnvironmentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.EnvironmentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.EnvironmentSummary =
      zio.aws.m2.model.EnvironmentSummary(
        creationTime,
        engineType,
        engineVersion,
        environmentArn,
        environmentId,
        instanceType,
        name,
        status
      )
    def creationTime: Timestamp
    def engineType: zio.aws.m2.model.EngineType
    def engineVersion: EngineVersion
    def environmentArn: Arn
    def environmentId: Identifier
    def instanceType: String20
    def name: EntityName
    def status: zio.aws.m2.model.EnvironmentLifecycle
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getEngineType: ZIO[Any, Nothing, zio.aws.m2.model.EngineType] =
      ZIO.succeed(engineType)
    def getEngineVersion: ZIO[Any, Nothing, EngineVersion] =
      ZIO.succeed(engineVersion)
    def getEnvironmentArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(environmentArn)
    def getEnvironmentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(environmentId)
    def getInstanceType: ZIO[Any, Nothing, String20] = ZIO.succeed(instanceType)
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getStatus: ZIO[Any, Nothing, zio.aws.m2.model.EnvironmentLifecycle] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.EnvironmentSummary
  ) extends zio.aws.m2.model.EnvironmentSummary.ReadOnly {
    override val creationTime: Timestamp =
      zio.aws.m2.model.primitives.Timestamp(impl.creationTime())
    override val engineType: zio.aws.m2.model.EngineType =
      zio.aws.m2.model.EngineType.wrap(impl.engineType())
    override val engineVersion: EngineVersion =
      zio.aws.m2.model.primitives.EngineVersion(impl.engineVersion())
    override val environmentArn: Arn =
      zio.aws.m2.model.primitives.Arn(impl.environmentArn())
    override val environmentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.environmentId())
    override val instanceType: String20 =
      zio.aws.m2.model.primitives.String20(impl.instanceType())
    override val name: EntityName =
      zio.aws.m2.model.primitives.EntityName(impl.name())
    override val status: zio.aws.m2.model.EnvironmentLifecycle =
      zio.aws.m2.model.EnvironmentLifecycle.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.EnvironmentSummary
  ): zio.aws.m2.model.EnvironmentSummary.ReadOnly = new Wrapper(impl)
}
