package zio.aws.m2.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentLifecycle {
  def unwrap: software.amazon.awssdk.services.m2.model.DeploymentLifecycle
}
object DeploymentLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.m2.model.DeploymentLifecycle
  ): zio.aws.m2.model.DeploymentLifecycle = value match {
    case software.amazon.awssdk.services.m2.model.DeploymentLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.m2.model.DeploymentLifecycle.DEPLOYING =>
      val r = Deploying
      r
    case software.amazon.awssdk.services.m2.model.DeploymentLifecycle.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.m2.model.DeploymentLifecycle.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.m2.model.DeploymentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.DeploymentLifecycle =
      software.amazon.awssdk.services.m2.model.DeploymentLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object Deploying extends zio.aws.m2.model.DeploymentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.DeploymentLifecycle =
      software.amazon.awssdk.services.m2.model.DeploymentLifecycle.DEPLOYING
  }
  case object Succeeded extends zio.aws.m2.model.DeploymentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.DeploymentLifecycle =
      software.amazon.awssdk.services.m2.model.DeploymentLifecycle.SUCCEEDED
  }
  case object Failed extends zio.aws.m2.model.DeploymentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.DeploymentLifecycle =
      software.amazon.awssdk.services.m2.model.DeploymentLifecycle.FAILED
  }
}
