package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class CreateDataSetImportTaskRequest(
    applicationId: Identifier,
    clientToken: Optional[String] = Optional.Absent,
    importConfig: zio.aws.m2.model.DataSetImportConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskRequest = {
    import CreateDataSetImportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .importConfig(importConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.m2.model.CreateDataSetImportTaskRequest.ReadOnly =
    zio.aws.m2.model.CreateDataSetImportTaskRequest.wrap(buildAwsValue())
}
object CreateDataSetImportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.CreateDataSetImportTaskRequest =
      zio.aws.m2.model.CreateDataSetImportTaskRequest(
        applicationId,
        clientToken.map(value => value),
        importConfig.asEditable
      )
    def applicationId: Identifier
    def clientToken: Optional[String]
    def importConfig: zio.aws.m2.model.DataSetImportConfig.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getImportConfig
        : ZIO[Any, Nothing, zio.aws.m2.model.DataSetImportConfig.ReadOnly] =
      ZIO.succeed(importConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskRequest
  ) extends zio.aws.m2.model.CreateDataSetImportTaskRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val importConfig: zio.aws.m2.model.DataSetImportConfig.ReadOnly =
      zio.aws.m2.model.DataSetImportConfig.wrap(impl.importConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskRequest
  ): zio.aws.m2.model.CreateDataSetImportTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
