package zio.aws.m2.model
import scala.jdk.CollectionConverters._
sealed trait BatchJobType {
  def unwrap: software.amazon.awssdk.services.m2.model.BatchJobType
}
object BatchJobType {
  def wrap(
      value: software.amazon.awssdk.services.m2.model.BatchJobType
  ): zio.aws.m2.model.BatchJobType = value match {
    case software.amazon.awssdk.services.m2.model.BatchJobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.m2.model.BatchJobType.VSE =>
      val r = VSE
      r
    case software.amazon.awssdk.services.m2.model.BatchJobType.JES2 =>
      val r = JES2
      r
    case software.amazon.awssdk.services.m2.model.BatchJobType.JES3 =>
      val r = JES3
      r
  }
  case object unknownToSdkVersion extends zio.aws.m2.model.BatchJobType {
    override def unwrap: software.amazon.awssdk.services.m2.model.BatchJobType =
      software.amazon.awssdk.services.m2.model.BatchJobType.UNKNOWN_TO_SDK_VERSION
  }
  case object VSE extends zio.aws.m2.model.BatchJobType {
    override def unwrap: software.amazon.awssdk.services.m2.model.BatchJobType =
      software.amazon.awssdk.services.m2.model.BatchJobType.VSE
  }
  case object JES2 extends zio.aws.m2.model.BatchJobType {
    override def unwrap: software.amazon.awssdk.services.m2.model.BatchJobType =
      software.amazon.awssdk.services.m2.model.BatchJobType.JES2
  }
  case object JES3 extends zio.aws.m2.model.BatchJobType {
    override def unwrap: software.amazon.awssdk.services.m2.model.BatchJobType =
      software.amazon.awssdk.services.m2.model.BatchJobType.JES3
  }
}
