package zio.aws.m2.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationVersionLifecycle {
  def unwrap
      : software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle
}
object ApplicationVersionLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle
  ): zio.aws.m2.model.ApplicationVersionLifecycle = value match {
    case software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle.AVAILABLE =>
      val r = Available
      r
    case software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.m2.model.ApplicationVersionLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating extends zio.aws.m2.model.ApplicationVersionLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle.CREATING
  }
  case object Available extends zio.aws.m2.model.ApplicationVersionLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle.AVAILABLE
  }
  case object Failed extends zio.aws.m2.model.ApplicationVersionLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle.FAILED
  }
}
