package zio.aws.m2
import zio.aws.m2.model.ListBatchJobDefinitionsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.m2.{M2AsyncClientBuilder, M2AsyncClient}
import software.amazon.awssdk.services.m2.model.{
  UpdateApplicationRequest,
  ListBatchJobExecutionsRequest,
  ListBatchJobExecutionsResponse,
  ListDataSetsRequest,
  GetApplicationVersionRequest,
  CancelBatchJobExecutionRequest,
  GetEnvironmentRequest,
  GetBatchJobExecutionRequest,
  DeleteApplicationRequest,
  ListEnvironmentsRequest,
  StartBatchJobResponse,
  DeploymentSummary,
  GetEnvironmentResponse,
  EngineVersionsSummary,
  StartApplicationRequest,
  DeleteApplicationFromEnvironmentRequest,
  BatchJobExecutionSummary,
  UpdateEnvironmentRequest,
  UpdateApplicationResponse,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  StartApplicationResponse,
  StartBatchJobRequest,
  GetApplicationVersionResponse,
  UpdateEnvironmentResponse,
  GetDataSetImportTaskRequest,
  CreateDeploymentResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListDataSetImportHistoryResponse,
  ListBatchJobDefinitionsResponse,
  ListApplicationsResponse,
  CancelBatchJobExecutionResponse,
  ListApplicationVersionsResponse,
  ListBatchJobDefinitionsRequest,
  ListDeploymentsRequest,
  GetApplicationRequest,
  CreateApplicationResponse,
  DeleteApplicationFromEnvironmentResponse,
  CreateDataSetImportTaskResponse,
  ListEngineVersionsRequest,
  StopApplicationResponse,
  UntagResourceRequest,
  BatchJobDefinition,
  DataSetSummary,
  DataSetImportTask,
  ListDeploymentsResponse,
  ListApplicationsRequest,
  ListEngineVersionsResponse,
  StopApplicationRequest,
  GetDataSetImportTaskResponse,
  CreateDeploymentRequest,
  CreateEnvironmentRequest,
  GetDeploymentRequest,
  GetDataSetDetailsRequest,
  DeleteEnvironmentRequest,
  ListApplicationVersionsRequest,
  GetBatchJobExecutionResponse,
  TagResourceResponse,
  ListDataSetImportHistoryRequest,
  ApplicationSummary,
  GetApplicationResponse,
  ApplicationVersionSummary,
  GetDeploymentResponse,
  ListEnvironmentsResponse,
  EnvironmentSummary,
  CreateEnvironmentResponse,
  CreateDataSetImportTaskRequest,
  DeleteApplicationResponse,
  TagResourceRequest,
  DeleteEnvironmentResponse,
  ListDataSetsResponse,
  GetDataSetDetailsResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.m2.paginators.{
  ListBatchJobExecutionsPublisher,
  ListEnvironmentsPublisher,
  ListBatchJobDefinitionsPublisher,
  ListEngineVersionsPublisher,
  ListDeploymentsPublisher,
  ListApplicationVersionsPublisher,
  ListDataSetsPublisher,
  ListDataSetImportHistoryPublisher,
  ListApplicationsPublisher
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait M2 extends AspectSupport[M2] {
  val api: M2AsyncClient
  def deleteEnvironment(
      request: zio.aws.m2.model.DeleteEnvironmentRequest
  ): IO[AwsError, zio.aws.m2.model.DeleteEnvironmentResponse.ReadOnly]
  def getApplication(
      request: zio.aws.m2.model.GetApplicationRequest
  ): IO[AwsError, zio.aws.m2.model.GetApplicationResponse.ReadOnly]
  def listBatchJobExecutions(
      request: zio.aws.m2.model.ListBatchJobExecutionsRequest
  ): ZStream[Any, AwsError, zio.aws.m2.model.BatchJobExecutionSummary.ReadOnly]
  def listBatchJobExecutionsPaginated(
      request: zio.aws.m2.model.ListBatchJobExecutionsRequest
  ): IO[AwsError, zio.aws.m2.model.ListBatchJobExecutionsResponse.ReadOnly]
  def deleteApplication(
      request: zio.aws.m2.model.DeleteApplicationRequest
  ): IO[AwsError, zio.aws.m2.model.DeleteApplicationResponse.ReadOnly]
  def createEnvironment(
      request: zio.aws.m2.model.CreateEnvironmentRequest
  ): IO[AwsError, zio.aws.m2.model.CreateEnvironmentResponse.ReadOnly]
  def getDataSetImportTask(
      request: zio.aws.m2.model.GetDataSetImportTaskRequest
  ): IO[AwsError, zio.aws.m2.model.GetDataSetImportTaskResponse.ReadOnly]
  def getEnvironment(
      request: zio.aws.m2.model.GetEnvironmentRequest
  ): IO[AwsError, zio.aws.m2.model.GetEnvironmentResponse.ReadOnly]
  def listEngineVersions(
      request: zio.aws.m2.model.ListEngineVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.m2.model.EngineVersionsSummary.ReadOnly]
  def listEngineVersionsPaginated(
      request: zio.aws.m2.model.ListEngineVersionsRequest
  ): IO[AwsError, zio.aws.m2.model.ListEngineVersionsResponse.ReadOnly]
  def getDeployment(
      request: zio.aws.m2.model.GetDeploymentRequest
  ): IO[AwsError, zio.aws.m2.model.GetDeploymentResponse.ReadOnly]
  def createApplication(
      request: zio.aws.m2.model.CreateApplicationRequest
  ): IO[AwsError, zio.aws.m2.model.CreateApplicationResponse.ReadOnly]
  def cancelBatchJobExecution(
      request: zio.aws.m2.model.CancelBatchJobExecutionRequest
  ): IO[AwsError, zio.aws.m2.model.CancelBatchJobExecutionResponse.ReadOnly]
  def listDataSets(
      request: zio.aws.m2.model.ListDataSetsRequest
  ): ZStream[Any, AwsError, zio.aws.m2.model.DataSetSummary.ReadOnly]
  def listDataSetsPaginated(
      request: zio.aws.m2.model.ListDataSetsRequest
  ): IO[AwsError, zio.aws.m2.model.ListDataSetsResponse.ReadOnly]
  def getBatchJobExecution(
      request: zio.aws.m2.model.GetBatchJobExecutionRequest
  ): IO[AwsError, zio.aws.m2.model.GetBatchJobExecutionResponse.ReadOnly]
  def getApplicationVersion(
      request: zio.aws.m2.model.GetApplicationVersionRequest
  ): IO[AwsError, zio.aws.m2.model.GetApplicationVersionResponse.ReadOnly]
  def deleteApplicationFromEnvironment(
      request: zio.aws.m2.model.DeleteApplicationFromEnvironmentRequest
  ): IO[
    AwsError,
    zio.aws.m2.model.DeleteApplicationFromEnvironmentResponse.ReadOnly
  ]
  def listDeployments(
      request: zio.aws.m2.model.ListDeploymentsRequest
  ): ZStream[Any, AwsError, zio.aws.m2.model.DeploymentSummary.ReadOnly]
  def listDeploymentsPaginated(
      request: zio.aws.m2.model.ListDeploymentsRequest
  ): IO[AwsError, zio.aws.m2.model.ListDeploymentsResponse.ReadOnly]
  def startApplication(
      request: zio.aws.m2.model.StartApplicationRequest
  ): IO[AwsError, zio.aws.m2.model.StartApplicationResponse.ReadOnly]
  def startBatchJob(
      request: zio.aws.m2.model.StartBatchJobRequest
  ): IO[AwsError, zio.aws.m2.model.StartBatchJobResponse.ReadOnly]
  def listEnvironments(
      request: zio.aws.m2.model.ListEnvironmentsRequest
  ): ZStream[Any, AwsError, zio.aws.m2.model.EnvironmentSummary.ReadOnly]
  def listEnvironmentsPaginated(
      request: zio.aws.m2.model.ListEnvironmentsRequest
  ): IO[AwsError, zio.aws.m2.model.ListEnvironmentsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.m2.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.m2.model.UntagResourceResponse.ReadOnly]
  def createDeployment(
      request: zio.aws.m2.model.CreateDeploymentRequest
  ): IO[AwsError, zio.aws.m2.model.CreateDeploymentResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.m2.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.m2.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.m2.model.TagResourceRequest
  ): IO[AwsError, zio.aws.m2.model.TagResourceResponse.ReadOnly]
  def listApplications(
      request: zio.aws.m2.model.ListApplicationsRequest
  ): ZStream[Any, AwsError, zio.aws.m2.model.ApplicationSummary.ReadOnly]
  def listApplicationsPaginated(
      request: zio.aws.m2.model.ListApplicationsRequest
  ): IO[AwsError, zio.aws.m2.model.ListApplicationsResponse.ReadOnly]
  def listDataSetImportHistory(
      request: zio.aws.m2.model.ListDataSetImportHistoryRequest
  ): ZStream[Any, AwsError, zio.aws.m2.model.DataSetImportTask.ReadOnly]
  def listDataSetImportHistoryPaginated(
      request: zio.aws.m2.model.ListDataSetImportHistoryRequest
  ): IO[AwsError, zio.aws.m2.model.ListDataSetImportHistoryResponse.ReadOnly]
  def updateEnvironment(
      request: zio.aws.m2.model.UpdateEnvironmentRequest
  ): IO[AwsError, zio.aws.m2.model.UpdateEnvironmentResponse.ReadOnly]
  def getDataSetDetails(
      request: zio.aws.m2.model.GetDataSetDetailsRequest
  ): IO[AwsError, zio.aws.m2.model.GetDataSetDetailsResponse.ReadOnly]
  def updateApplication(
      request: zio.aws.m2.model.UpdateApplicationRequest
  ): IO[AwsError, zio.aws.m2.model.UpdateApplicationResponse.ReadOnly]
  def listApplicationVersions(
      request: zio.aws.m2.model.ListApplicationVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.m2.model.ApplicationVersionSummary.ReadOnly]
  def listApplicationVersionsPaginated(
      request: zio.aws.m2.model.ListApplicationVersionsRequest
  ): IO[AwsError, zio.aws.m2.model.ListApplicationVersionsResponse.ReadOnly]
  def createDataSetImportTask(
      request: zio.aws.m2.model.CreateDataSetImportTaskRequest
  ): IO[AwsError, zio.aws.m2.model.CreateDataSetImportTaskResponse.ReadOnly]
  def stopApplication(
      request: zio.aws.m2.model.StopApplicationRequest
  ): IO[AwsError, zio.aws.m2.model.StopApplicationResponse.ReadOnly]
  def listBatchJobDefinitions(
      request: zio.aws.m2.model.ListBatchJobDefinitionsRequest
  ): ZStream[Any, AwsError, zio.aws.m2.model.BatchJobDefinition.ReadOnly]
  def listBatchJobDefinitionsPaginated(
      request: zio.aws.m2.model.ListBatchJobDefinitionsRequest
  ): IO[AwsError, ReadOnly]
}
object M2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, M2] = customized(identity)
  def customized(
      customization: M2AsyncClientBuilder => M2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, M2] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: M2AsyncClientBuilder => M2AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, M2] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = M2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[M2AsyncClient, M2AsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[M2AsyncClient, M2AsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new M2Impl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class M2Impl[R](
      override val api: M2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends M2
      with AwsServiceBase[R] {
    override val serviceName: String = "M2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): M2Impl[R1] = new M2Impl(api, newAspect, r)
    def deleteEnvironment(
        request: zio.aws.m2.model.DeleteEnvironmentRequest
    ): IO[AwsError, zio.aws.m2.model.DeleteEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[DeleteEnvironmentRequest, DeleteEnvironmentResponse](
        "deleteEnvironment",
        api.deleteEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.DeleteEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def getApplication(
        request: zio.aws.m2.model.GetApplicationRequest
    ): IO[AwsError, zio.aws.m2.model.GetApplicationResponse.ReadOnly] =
      asyncRequestResponse[GetApplicationRequest, GetApplicationResponse](
        "getApplication",
        api.getApplication
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.GetApplicationResponse.wrap)
        .provideEnvironment(r)
    def listBatchJobExecutions(
        request: zio.aws.m2.model.ListBatchJobExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.m2.model.BatchJobExecutionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListBatchJobExecutionsRequest,
      BatchJobExecutionSummary,
      ListBatchJobExecutionsPublisher
    ](
      "listBatchJobExecutions",
      api.listBatchJobExecutionsPaginator,
      _.batchJobExecutions()
    )(request.buildAwsValue())
      .map(item => zio.aws.m2.model.BatchJobExecutionSummary.wrap(item))
      .provideEnvironment(r)
    def listBatchJobExecutionsPaginated(
        request: zio.aws.m2.model.ListBatchJobExecutionsRequest
    ): IO[AwsError, zio.aws.m2.model.ListBatchJobExecutionsResponse.ReadOnly] =
      asyncRequestResponse[
        ListBatchJobExecutionsRequest,
        ListBatchJobExecutionsResponse
      ]("listBatchJobExecutions", api.listBatchJobExecutions)(
        request.buildAwsValue()
      ).map(zio.aws.m2.model.ListBatchJobExecutionsResponse.wrap)
        .provideEnvironment(r)
    def deleteApplication(
        request: zio.aws.m2.model.DeleteApplicationRequest
    ): IO[AwsError, zio.aws.m2.model.DeleteApplicationResponse.ReadOnly] =
      asyncRequestResponse[DeleteApplicationRequest, DeleteApplicationResponse](
        "deleteApplication",
        api.deleteApplication
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.DeleteApplicationResponse.wrap)
        .provideEnvironment(r)
    def createEnvironment(
        request: zio.aws.m2.model.CreateEnvironmentRequest
    ): IO[AwsError, zio.aws.m2.model.CreateEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[CreateEnvironmentRequest, CreateEnvironmentResponse](
        "createEnvironment",
        api.createEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.CreateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def getDataSetImportTask(
        request: zio.aws.m2.model.GetDataSetImportTaskRequest
    ): IO[AwsError, zio.aws.m2.model.GetDataSetImportTaskResponse.ReadOnly] =
      asyncRequestResponse[
        GetDataSetImportTaskRequest,
        GetDataSetImportTaskResponse
      ]("getDataSetImportTask", api.getDataSetImportTask)(
        request.buildAwsValue()
      ).map(zio.aws.m2.model.GetDataSetImportTaskResponse.wrap)
        .provideEnvironment(r)
    def getEnvironment(
        request: zio.aws.m2.model.GetEnvironmentRequest
    ): IO[AwsError, zio.aws.m2.model.GetEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[GetEnvironmentRequest, GetEnvironmentResponse](
        "getEnvironment",
        api.getEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.GetEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def listEngineVersions(
        request: zio.aws.m2.model.ListEngineVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.m2.model.EngineVersionsSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListEngineVersionsRequest,
        EngineVersionsSummary,
        ListEngineVersionsPublisher
      ](
        "listEngineVersions",
        api.listEngineVersionsPaginator,
        _.engineVersions()
      )(request.buildAwsValue())
        .map(item => zio.aws.m2.model.EngineVersionsSummary.wrap(item))
        .provideEnvironment(r)
    def listEngineVersionsPaginated(
        request: zio.aws.m2.model.ListEngineVersionsRequest
    ): IO[AwsError, zio.aws.m2.model.ListEngineVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        ListEngineVersionsRequest,
        ListEngineVersionsResponse
      ]("listEngineVersions", api.listEngineVersions)(request.buildAwsValue())
        .map(zio.aws.m2.model.ListEngineVersionsResponse.wrap)
        .provideEnvironment(r)
    def getDeployment(
        request: zio.aws.m2.model.GetDeploymentRequest
    ): IO[AwsError, zio.aws.m2.model.GetDeploymentResponse.ReadOnly] =
      asyncRequestResponse[GetDeploymentRequest, GetDeploymentResponse](
        "getDeployment",
        api.getDeployment
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.GetDeploymentResponse.wrap)
        .provideEnvironment(r)
    def createApplication(
        request: zio.aws.m2.model.CreateApplicationRequest
    ): IO[AwsError, zio.aws.m2.model.CreateApplicationResponse.ReadOnly] =
      asyncRequestResponse[CreateApplicationRequest, CreateApplicationResponse](
        "createApplication",
        api.createApplication
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.CreateApplicationResponse.wrap)
        .provideEnvironment(r)
    def cancelBatchJobExecution(
        request: zio.aws.m2.model.CancelBatchJobExecutionRequest
    ): IO[AwsError, zio.aws.m2.model.CancelBatchJobExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        CancelBatchJobExecutionRequest,
        CancelBatchJobExecutionResponse
      ]("cancelBatchJobExecution", api.cancelBatchJobExecution)(
        request.buildAwsValue()
      ).map(zio.aws.m2.model.CancelBatchJobExecutionResponse.wrap)
        .provideEnvironment(r)
    def listDataSets(
        request: zio.aws.m2.model.ListDataSetsRequest
    ): ZStream[Any, AwsError, zio.aws.m2.model.DataSetSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListDataSetsRequest,
        DataSetSummary,
        ListDataSetsPublisher
      ]("listDataSets", api.listDataSetsPaginator, _.dataSets())(
        request.buildAwsValue()
      ).map(item => zio.aws.m2.model.DataSetSummary.wrap(item))
        .provideEnvironment(r)
    def listDataSetsPaginated(
        request: zio.aws.m2.model.ListDataSetsRequest
    ): IO[AwsError, zio.aws.m2.model.ListDataSetsResponse.ReadOnly] =
      asyncRequestResponse[ListDataSetsRequest, ListDataSetsResponse](
        "listDataSets",
        api.listDataSets
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.ListDataSetsResponse.wrap)
        .provideEnvironment(r)
    def getBatchJobExecution(
        request: zio.aws.m2.model.GetBatchJobExecutionRequest
    ): IO[AwsError, zio.aws.m2.model.GetBatchJobExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        GetBatchJobExecutionRequest,
        GetBatchJobExecutionResponse
      ]("getBatchJobExecution", api.getBatchJobExecution)(
        request.buildAwsValue()
      ).map(zio.aws.m2.model.GetBatchJobExecutionResponse.wrap)
        .provideEnvironment(r)
    def getApplicationVersion(
        request: zio.aws.m2.model.GetApplicationVersionRequest
    ): IO[AwsError, zio.aws.m2.model.GetApplicationVersionResponse.ReadOnly] =
      asyncRequestResponse[
        GetApplicationVersionRequest,
        GetApplicationVersionResponse
      ]("getApplicationVersion", api.getApplicationVersion)(
        request.buildAwsValue()
      ).map(zio.aws.m2.model.GetApplicationVersionResponse.wrap)
        .provideEnvironment(r)
    def deleteApplicationFromEnvironment(
        request: zio.aws.m2.model.DeleteApplicationFromEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.m2.model.DeleteApplicationFromEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteApplicationFromEnvironmentRequest,
      DeleteApplicationFromEnvironmentResponse
    ]("deleteApplicationFromEnvironment", api.deleteApplicationFromEnvironment)(
      request.buildAwsValue()
    ).map(zio.aws.m2.model.DeleteApplicationFromEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def listDeployments(
        request: zio.aws.m2.model.ListDeploymentsRequest
    ): ZStream[Any, AwsError, zio.aws.m2.model.DeploymentSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListDeploymentsRequest,
        DeploymentSummary,
        ListDeploymentsPublisher
      ]("listDeployments", api.listDeploymentsPaginator, _.deployments())(
        request.buildAwsValue()
      ).map(item => zio.aws.m2.model.DeploymentSummary.wrap(item))
        .provideEnvironment(r)
    def listDeploymentsPaginated(
        request: zio.aws.m2.model.ListDeploymentsRequest
    ): IO[AwsError, zio.aws.m2.model.ListDeploymentsResponse.ReadOnly] =
      asyncRequestResponse[ListDeploymentsRequest, ListDeploymentsResponse](
        "listDeployments",
        api.listDeployments
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.ListDeploymentsResponse.wrap)
        .provideEnvironment(r)
    def startApplication(
        request: zio.aws.m2.model.StartApplicationRequest
    ): IO[AwsError, zio.aws.m2.model.StartApplicationResponse.ReadOnly] =
      asyncRequestResponse[StartApplicationRequest, StartApplicationResponse](
        "startApplication",
        api.startApplication
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.StartApplicationResponse.wrap)
        .provideEnvironment(r)
    def startBatchJob(
        request: zio.aws.m2.model.StartBatchJobRequest
    ): IO[AwsError, zio.aws.m2.model.StartBatchJobResponse.ReadOnly] =
      asyncRequestResponse[StartBatchJobRequest, StartBatchJobResponse](
        "startBatchJob",
        api.startBatchJob
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.StartBatchJobResponse.wrap)
        .provideEnvironment(r)
    def listEnvironments(
        request: zio.aws.m2.model.ListEnvironmentsRequest
    ): ZStream[Any, AwsError, zio.aws.m2.model.EnvironmentSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListEnvironmentsRequest,
        EnvironmentSummary,
        ListEnvironmentsPublisher
      ]("listEnvironments", api.listEnvironmentsPaginator, _.environments())(
        request.buildAwsValue()
      ).map(item => zio.aws.m2.model.EnvironmentSummary.wrap(item))
        .provideEnvironment(r)
    def listEnvironmentsPaginated(
        request: zio.aws.m2.model.ListEnvironmentsRequest
    ): IO[AwsError, zio.aws.m2.model.ListEnvironmentsResponse.ReadOnly] =
      asyncRequestResponse[ListEnvironmentsRequest, ListEnvironmentsResponse](
        "listEnvironments",
        api.listEnvironments
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.ListEnvironmentsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.m2.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.m2.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createDeployment(
        request: zio.aws.m2.model.CreateDeploymentRequest
    ): IO[AwsError, zio.aws.m2.model.CreateDeploymentResponse.ReadOnly] =
      asyncRequestResponse[CreateDeploymentRequest, CreateDeploymentResponse](
        "createDeployment",
        api.createDeployment
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.CreateDeploymentResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.m2.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.m2.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.m2.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.m2.model.TagResourceRequest
    ): IO[AwsError, zio.aws.m2.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listApplications(
        request: zio.aws.m2.model.ListApplicationsRequest
    ): ZStream[Any, AwsError, zio.aws.m2.model.ApplicationSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListApplicationsRequest,
        ApplicationSummary,
        ListApplicationsPublisher
      ]("listApplications", api.listApplicationsPaginator, _.applications())(
        request.buildAwsValue()
      ).map(item => zio.aws.m2.model.ApplicationSummary.wrap(item))
        .provideEnvironment(r)
    def listApplicationsPaginated(
        request: zio.aws.m2.model.ListApplicationsRequest
    ): IO[AwsError, zio.aws.m2.model.ListApplicationsResponse.ReadOnly] =
      asyncRequestResponse[ListApplicationsRequest, ListApplicationsResponse](
        "listApplications",
        api.listApplications
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.ListApplicationsResponse.wrap)
        .provideEnvironment(r)
    def listDataSetImportHistory(
        request: zio.aws.m2.model.ListDataSetImportHistoryRequest
    ): ZStream[Any, AwsError, zio.aws.m2.model.DataSetImportTask.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListDataSetImportHistoryRequest,
        DataSetImportTask,
        ListDataSetImportHistoryPublisher
      ](
        "listDataSetImportHistory",
        api.listDataSetImportHistoryPaginator,
        _.dataSetImportTasks()
      )(request.buildAwsValue())
        .map(item => zio.aws.m2.model.DataSetImportTask.wrap(item))
        .provideEnvironment(r)
    def listDataSetImportHistoryPaginated(
        request: zio.aws.m2.model.ListDataSetImportHistoryRequest
    ): IO[
      AwsError,
      zio.aws.m2.model.ListDataSetImportHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDataSetImportHistoryRequest,
      ListDataSetImportHistoryResponse
    ]("listDataSetImportHistory", api.listDataSetImportHistory)(
      request.buildAwsValue()
    ).map(zio.aws.m2.model.ListDataSetImportHistoryResponse.wrap)
      .provideEnvironment(r)
    def updateEnvironment(
        request: zio.aws.m2.model.UpdateEnvironmentRequest
    ): IO[AwsError, zio.aws.m2.model.UpdateEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[UpdateEnvironmentRequest, UpdateEnvironmentResponse](
        "updateEnvironment",
        api.updateEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.UpdateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def getDataSetDetails(
        request: zio.aws.m2.model.GetDataSetDetailsRequest
    ): IO[AwsError, zio.aws.m2.model.GetDataSetDetailsResponse.ReadOnly] =
      asyncRequestResponse[GetDataSetDetailsRequest, GetDataSetDetailsResponse](
        "getDataSetDetails",
        api.getDataSetDetails
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.GetDataSetDetailsResponse.wrap)
        .provideEnvironment(r)
    def updateApplication(
        request: zio.aws.m2.model.UpdateApplicationRequest
    ): IO[AwsError, zio.aws.m2.model.UpdateApplicationResponse.ReadOnly] =
      asyncRequestResponse[UpdateApplicationRequest, UpdateApplicationResponse](
        "updateApplication",
        api.updateApplication
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.UpdateApplicationResponse.wrap)
        .provideEnvironment(r)
    def listApplicationVersions(
        request: zio.aws.m2.model.ListApplicationVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.m2.model.ApplicationVersionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListApplicationVersionsRequest,
      ApplicationVersionSummary,
      ListApplicationVersionsPublisher
    ](
      "listApplicationVersions",
      api.listApplicationVersionsPaginator,
      _.applicationVersions()
    )(request.buildAwsValue())
      .map(item => zio.aws.m2.model.ApplicationVersionSummary.wrap(item))
      .provideEnvironment(r)
    def listApplicationVersionsPaginated(
        request: zio.aws.m2.model.ListApplicationVersionsRequest
    ): IO[AwsError, zio.aws.m2.model.ListApplicationVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        ListApplicationVersionsRequest,
        ListApplicationVersionsResponse
      ]("listApplicationVersions", api.listApplicationVersions)(
        request.buildAwsValue()
      ).map(zio.aws.m2.model.ListApplicationVersionsResponse.wrap)
        .provideEnvironment(r)
    def createDataSetImportTask(
        request: zio.aws.m2.model.CreateDataSetImportTaskRequest
    ): IO[AwsError, zio.aws.m2.model.CreateDataSetImportTaskResponse.ReadOnly] =
      asyncRequestResponse[
        CreateDataSetImportTaskRequest,
        CreateDataSetImportTaskResponse
      ]("createDataSetImportTask", api.createDataSetImportTask)(
        request.buildAwsValue()
      ).map(zio.aws.m2.model.CreateDataSetImportTaskResponse.wrap)
        .provideEnvironment(r)
    def stopApplication(
        request: zio.aws.m2.model.StopApplicationRequest
    ): IO[AwsError, zio.aws.m2.model.StopApplicationResponse.ReadOnly] =
      asyncRequestResponse[StopApplicationRequest, StopApplicationResponse](
        "stopApplication",
        api.stopApplication
      )(request.buildAwsValue())
        .map(zio.aws.m2.model.StopApplicationResponse.wrap)
        .provideEnvironment(r)
    def listBatchJobDefinitions(
        request: zio.aws.m2.model.ListBatchJobDefinitionsRequest
    ): ZStream[Any, AwsError, zio.aws.m2.model.BatchJobDefinition.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListBatchJobDefinitionsRequest,
        BatchJobDefinition,
        ListBatchJobDefinitionsPublisher
      ](
        "listBatchJobDefinitions",
        api.listBatchJobDefinitionsPaginator,
        _.batchJobDefinitions()
      )(request.buildAwsValue())
        .map(item => zio.aws.m2.model.BatchJobDefinition.wrap(item))
        .provideEnvironment(r)
    def listBatchJobDefinitionsPaginated(
        request: zio.aws.m2.model.ListBatchJobDefinitionsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ListBatchJobDefinitionsRequest,
      ListBatchJobDefinitionsResponse
    ]("listBatchJobDefinitions", api.listBatchJobDefinitions)(
      request.buildAwsValue()
    ).map(zio.aws.m2.model.ListBatchJobDefinitionsResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteEnvironment(
      request: zio.aws.m2.model.DeleteEnvironmentRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.DeleteEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEnvironment(request))
  def getApplication(request: zio.aws.m2.model.GetApplicationRequest): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.GetApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplication(request))
  def listBatchJobExecutions(
      request: zio.aws.m2.model.ListBatchJobExecutionsRequest
  ): ZStream[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.BatchJobExecutionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listBatchJobExecutions(request))
  def listBatchJobExecutionsPaginated(
      request: zio.aws.m2.model.ListBatchJobExecutionsRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.ListBatchJobExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBatchJobExecutionsPaginated(request))
  def deleteApplication(
      request: zio.aws.m2.model.DeleteApplicationRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.DeleteApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplication(request))
  def createEnvironment(
      request: zio.aws.m2.model.CreateEnvironmentRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.CreateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironment(request))
  def getDataSetImportTask(
      request: zio.aws.m2.model.GetDataSetImportTaskRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.GetDataSetImportTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataSetImportTask(request))
  def getEnvironment(request: zio.aws.m2.model.GetEnvironmentRequest): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.GetEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironment(request))
  def listEngineVersions(
      request: zio.aws.m2.model.ListEngineVersionsRequest
  ): ZStream[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.EngineVersionsSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEngineVersions(request))
  def listEngineVersionsPaginated(
      request: zio.aws.m2.model.ListEngineVersionsRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.ListEngineVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEngineVersionsPaginated(request))
  def getDeployment(request: zio.aws.m2.model.GetDeploymentRequest): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.GetDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeployment(request))
  def createApplication(
      request: zio.aws.m2.model.CreateApplicationRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def cancelBatchJobExecution(
      request: zio.aws.m2.model.CancelBatchJobExecutionRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.CancelBatchJobExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelBatchJobExecution(request))
  def listDataSets(request: zio.aws.m2.model.ListDataSetsRequest): ZStream[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.DataSetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataSets(request))
  def listDataSetsPaginated(request: zio.aws.m2.model.ListDataSetsRequest): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.ListDataSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataSetsPaginated(request))
  def getBatchJobExecution(
      request: zio.aws.m2.model.GetBatchJobExecutionRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.GetBatchJobExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBatchJobExecution(request))
  def getApplicationVersion(
      request: zio.aws.m2.model.GetApplicationVersionRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.GetApplicationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplicationVersion(request))
  def deleteApplicationFromEnvironment(
      request: zio.aws.m2.model.DeleteApplicationFromEnvironmentRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.DeleteApplicationFromEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplicationFromEnvironment(request))
  def listDeployments(
      request: zio.aws.m2.model.ListDeploymentsRequest
  ): ZStream[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.DeploymentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDeployments(request))
  def listDeploymentsPaginated(
      request: zio.aws.m2.model.ListDeploymentsRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.ListDeploymentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeploymentsPaginated(request))
  def startApplication(request: zio.aws.m2.model.StartApplicationRequest): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.StartApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startApplication(request))
  def startBatchJob(request: zio.aws.m2.model.StartBatchJobRequest): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.StartBatchJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startBatchJob(request))
  def listEnvironments(
      request: zio.aws.m2.model.ListEnvironmentsRequest
  ): ZStream[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.EnvironmentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironments(request))
  def listEnvironmentsPaginated(
      request: zio.aws.m2.model.ListEnvironmentsRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.ListEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentsPaginated(request))
  def untagResource(request: zio.aws.m2.model.UntagResourceRequest): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createDeployment(request: zio.aws.m2.model.CreateDeploymentRequest): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.CreateDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeployment(request))
  def listTagsForResource(
      request: zio.aws.m2.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.m2.model.TagResourceRequest): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listApplications(
      request: zio.aws.m2.model.ListApplicationsRequest
  ): ZStream[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.ApplicationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplications(request))
  def listApplicationsPaginated(
      request: zio.aws.m2.model.ListApplicationsRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.ListApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationsPaginated(request))
  def listDataSetImportHistory(
      request: zio.aws.m2.model.ListDataSetImportHistoryRequest
  ): ZStream[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.DataSetImportTask.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataSetImportHistory(request))
  def listDataSetImportHistoryPaginated(
      request: zio.aws.m2.model.ListDataSetImportHistoryRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.ListDataSetImportHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataSetImportHistoryPaginated(request))
  def updateEnvironment(
      request: zio.aws.m2.model.UpdateEnvironmentRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.UpdateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironment(request))
  def getDataSetDetails(
      request: zio.aws.m2.model.GetDataSetDetailsRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.GetDataSetDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataSetDetails(request))
  def updateApplication(
      request: zio.aws.m2.model.UpdateApplicationRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.UpdateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplication(request))
  def listApplicationVersions(
      request: zio.aws.m2.model.ListApplicationVersionsRequest
  ): ZStream[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.ApplicationVersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplicationVersions(request))
  def listApplicationVersionsPaginated(
      request: zio.aws.m2.model.ListApplicationVersionsRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.ListApplicationVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationVersionsPaginated(request))
  def createDataSetImportTask(
      request: zio.aws.m2.model.CreateDataSetImportTaskRequest
  ): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.CreateDataSetImportTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataSetImportTask(request))
  def stopApplication(request: zio.aws.m2.model.StopApplicationRequest): ZIO[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.StopApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopApplication(request))
  def listBatchJobDefinitions(
      request: zio.aws.m2.model.ListBatchJobDefinitionsRequest
  ): ZStream[
    zio.aws.m2.M2,
    AwsError,
    zio.aws.m2.model.BatchJobDefinition.ReadOnly
  ] = ZStream.serviceWithStream(_.listBatchJobDefinitions(request))
  def listBatchJobDefinitionsPaginated(
      request: zio.aws.m2.model.ListBatchJobDefinitionsRequest
  ): ZIO[zio.aws.m2.M2, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listBatchJobDefinitionsPaginated(request))
}
