package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class RecordLength(max: Integer, min: Integer) {
  def buildAwsValue(): software.amazon.awssdk.services.m2.model.RecordLength = {
    import RecordLength.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.RecordLength
      .builder()
      .max(max: java.lang.Integer)
      .min(min: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.RecordLength.ReadOnly =
    zio.aws.m2.model.RecordLength.wrap(buildAwsValue())
}
object RecordLength {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.m2.model.RecordLength] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.RecordLength =
      zio.aws.m2.model.RecordLength(max, min)
    def max: Integer
    def min: Integer
    def getMax: ZIO[Any, Nothing, Integer] = ZIO.succeed(max)
    def getMin: ZIO[Any, Nothing, Integer] = ZIO.succeed(min)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.RecordLength
  ) extends zio.aws.m2.model.RecordLength.ReadOnly {
    override val max: Integer = impl.max(): Integer
    override val min: Integer = impl.min(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.RecordLength
  ): zio.aws.m2.model.RecordLength.ReadOnly = new Wrapper(impl)
}
