package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PendingMaintenance(
    engineVersion: Optional[String] = Optional.Absent,
    schedule: Optional[zio.aws.m2.model.MaintenanceSchedule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.PendingMaintenance = {
    import PendingMaintenance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.PendingMaintenance
      .builder()
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.PendingMaintenance.ReadOnly =
    zio.aws.m2.model.PendingMaintenance.wrap(buildAwsValue())
}
object PendingMaintenance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.PendingMaintenance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.PendingMaintenance =
      zio.aws.m2.model.PendingMaintenance(
        engineVersion.map(value => value),
        schedule.map(value => value.asEditable)
      )
    def engineVersion: Optional[String]
    def schedule: Optional[zio.aws.m2.model.MaintenanceSchedule.ReadOnly]
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.m2.model.MaintenanceSchedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.PendingMaintenance
  ) extends zio.aws.m2.model.PendingMaintenance.ReadOnly {
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val schedule
        : Optional[zio.aws.m2.model.MaintenanceSchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.m2.model.MaintenanceSchedule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.PendingMaintenance
  ): zio.aws.m2.model.PendingMaintenance.ReadOnly = new Wrapper(impl)
}
