package zio.aws.m2.model
import zio.aws.m2.model.primitives.{NextToken, MaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEngineVersionsRequest(
    engineType: Optional[zio.aws.m2.model.EngineType] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest = {
    import ListEngineVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest
      .builder()
      .optionallyWith(engineType.map(value => value.unwrap))(_.engineType)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListEngineVersionsRequest.ReadOnly =
    zio.aws.m2.model.ListEngineVersionsRequest.wrap(buildAwsValue())
}
object ListEngineVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListEngineVersionsRequest =
      zio.aws.m2.model.ListEngineVersionsRequest(
        engineType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def engineType: Optional[zio.aws.m2.model.EngineType]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getEngineType: ZIO[Any, AwsError, zio.aws.m2.model.EngineType] =
      AwsError.unwrapOptionField("engineType", engineType)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest
  ) extends zio.aws.m2.model.ListEngineVersionsRequest.ReadOnly {
    override val engineType: Optional[zio.aws.m2.model.EngineType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineType())
        .map(value => zio.aws.m2.model.EngineType.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.m2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest
  ): zio.aws.m2.model.ListEngineVersionsRequest.ReadOnly = new Wrapper(impl)
}
