package zio.aws.m2.model
import zio.aws.m2.model.primitives.{NextToken, MaxResults, Identifier}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBatchJobDefinitionsRequest(
    applicationId: Identifier,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    prefix: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest = {
    import ListBatchJobDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListBatchJobDefinitionsRequest.ReadOnly =
    zio.aws.m2.model.ListBatchJobDefinitionsRequest.wrap(buildAwsValue())
}
object ListBatchJobDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListBatchJobDefinitionsRequest =
      zio.aws.m2.model.ListBatchJobDefinitionsRequest(
        applicationId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        prefix.map(value => value)
      )
    def applicationId: Identifier
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def prefix: Optional[String]
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest
  ) extends zio.aws.m2.model.ListBatchJobDefinitionsRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.m2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
    override val prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest
  ): zio.aws.m2.model.ListBatchJobDefinitionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
