package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.{String2000, String200, Timestamp, Integer}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetDataSetDetailsResponse(
    blocksize: Optional[Integer] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    dataSetName: String200,
    dataSetOrg: Optional[zio.aws.m2.model.DatasetDetailOrgAttributes] =
      Optional.Absent,
    lastReferencedTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    location: Optional[String2000] = Optional.Absent,
    recordLength: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetDataSetDetailsResponse = {
    import GetDataSetDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetDataSetDetailsResponse
      .builder()
      .optionallyWith(blocksize.map(value => value: java.lang.Integer))(
        _.blocksize
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .dataSetName(String200.unwrap(dataSetName): java.lang.String)
      .optionallyWith(dataSetOrg.map(value => value.buildAwsValue()))(
        _.dataSetOrg
      )
      .optionallyWith(
        lastReferencedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastReferencedTime)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        location.map(value => String2000.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(recordLength.map(value => value: java.lang.Integer))(
        _.recordLength
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetDataSetDetailsResponse.ReadOnly =
    zio.aws.m2.model.GetDataSetDetailsResponse.wrap(buildAwsValue())
}
object GetDataSetDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetDataSetDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetDataSetDetailsResponse =
      zio.aws.m2.model.GetDataSetDetailsResponse(
        blocksize.map(value => value),
        creationTime.map(value => value),
        dataSetName,
        dataSetOrg.map(value => value.asEditable),
        lastReferencedTime.map(value => value),
        lastUpdatedTime.map(value => value),
        location.map(value => value),
        recordLength.map(value => value)
      )
    def blocksize: Optional[Integer]
    def creationTime: Optional[Timestamp]
    def dataSetName: String200
    def dataSetOrg
        : Optional[zio.aws.m2.model.DatasetDetailOrgAttributes.ReadOnly]
    def lastReferencedTime: Optional[Timestamp]
    def lastUpdatedTime: Optional[Timestamp]
    def location: Optional[String2000]
    def recordLength: Optional[Integer]
    def getBlocksize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("blocksize", blocksize)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDataSetName: ZIO[Any, Nothing, String200] = ZIO.succeed(dataSetName)
    def getDataSetOrg: ZIO[
      Any,
      AwsError,
      zio.aws.m2.model.DatasetDetailOrgAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("dataSetOrg", dataSetOrg)
    def getLastReferencedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastReferencedTime", lastReferencedTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getLocation: ZIO[Any, AwsError, String2000] =
      AwsError.unwrapOptionField("location", location)
    def getRecordLength: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("recordLength", recordLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetDataSetDetailsResponse
  ) extends zio.aws.m2.model.GetDataSetDetailsResponse.ReadOnly {
    override val blocksize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.blocksize())
      .map(value => value: Integer)
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val dataSetName: String200 =
      zio.aws.m2.model.primitives.String200(impl.dataSetName())
    override val dataSetOrg
        : Optional[zio.aws.m2.model.DatasetDetailOrgAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSetOrg())
        .map(value => zio.aws.m2.model.DatasetDetailOrgAttributes.wrap(value))
    override val lastReferencedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastReferencedTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val location: Optional[String2000] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => zio.aws.m2.model.primitives.String2000(value))
    override val recordLength: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.recordLength())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetDataSetDetailsResponse
  ): zio.aws.m2.model.GetDataSetDetailsResponse.ReadOnly = new Wrapper(impl)
}
