package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.{String100, Timestamp, Identifier}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetBatchJobExecutionResponse(
    applicationId: Identifier,
    batchJobIdentifier: Optional[zio.aws.m2.model.BatchJobIdentifier] =
      Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    executionId: Identifier,
    jobId: Optional[String100] = Optional.Absent,
    jobName: Optional[String100] = Optional.Absent,
    jobType: Optional[zio.aws.m2.model.BatchJobType] = Optional.Absent,
    jobUser: Optional[String100] = Optional.Absent,
    returnCode: Optional[String] = Optional.Absent,
    startTime: Timestamp,
    status: zio.aws.m2.model.BatchJobExecutionStatus,
    statusReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetBatchJobExecutionResponse = {
    import GetBatchJobExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetBatchJobExecutionResponse
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .optionallyWith(batchJobIdentifier.map(value => value.buildAwsValue()))(
        _.batchJobIdentifier
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .executionId(Identifier.unwrap(executionId): java.lang.String)
      .optionallyWith(
        jobId.map(value => String100.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobName.map(value => String100.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(
        jobUser.map(value => String100.unwrap(value): java.lang.String)
      )(_.jobUser)
      .optionallyWith(returnCode.map(value => value: java.lang.String))(
        _.returnCode
      )
      .startTime(Timestamp.unwrap(startTime): Instant)
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetBatchJobExecutionResponse.ReadOnly =
    zio.aws.m2.model.GetBatchJobExecutionResponse.wrap(buildAwsValue())
}
object GetBatchJobExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetBatchJobExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetBatchJobExecutionResponse =
      zio.aws.m2.model.GetBatchJobExecutionResponse(
        applicationId,
        batchJobIdentifier.map(value => value.asEditable),
        endTime.map(value => value),
        executionId,
        jobId.map(value => value),
        jobName.map(value => value),
        jobType.map(value => value),
        jobUser.map(value => value),
        returnCode.map(value => value),
        startTime,
        status,
        statusReason.map(value => value)
      )
    def applicationId: Identifier
    def batchJobIdentifier
        : Optional[zio.aws.m2.model.BatchJobIdentifier.ReadOnly]
    def endTime: Optional[Timestamp]
    def executionId: Identifier
    def jobId: Optional[String100]
    def jobName: Optional[String100]
    def jobType: Optional[zio.aws.m2.model.BatchJobType]
    def jobUser: Optional[String100]
    def returnCode: Optional[String]
    def startTime: Timestamp
    def status: zio.aws.m2.model.BatchJobExecutionStatus
    def statusReason: Optional[String]
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getBatchJobIdentifier
        : ZIO[Any, AwsError, zio.aws.m2.model.BatchJobIdentifier.ReadOnly] =
      AwsError.unwrapOptionField("batchJobIdentifier", batchJobIdentifier)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getExecutionId: ZIO[Any, Nothing, Identifier] = ZIO.succeed(executionId)
    def getJobId: ZIO[Any, AwsError, String100] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobName: ZIO[Any, AwsError, String100] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobType: ZIO[Any, AwsError, zio.aws.m2.model.BatchJobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getJobUser: ZIO[Any, AwsError, String100] =
      AwsError.unwrapOptionField("jobUser", jobUser)
    def getReturnCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("returnCode", returnCode)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getStatus: ZIO[Any, Nothing, zio.aws.m2.model.BatchJobExecutionStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetBatchJobExecutionResponse
  ) extends zio.aws.m2.model.GetBatchJobExecutionResponse.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val batchJobIdentifier
        : Optional[zio.aws.m2.model.BatchJobIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchJobIdentifier())
        .map(value => zio.aws.m2.model.BatchJobIdentifier.wrap(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val executionId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.executionId())
    override val jobId: Optional[String100] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.m2.model.primitives.String100(value))
    override val jobName: Optional[String100] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.m2.model.primitives.String100(value))
    override val jobType: Optional[zio.aws.m2.model.BatchJobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value => zio.aws.m2.model.BatchJobType.wrap(value))
    override val jobUser: Optional[String100] = zio.aws.core.internal
      .optionalFromNullable(impl.jobUser())
      .map(value => zio.aws.m2.model.primitives.String100(value))
    override val returnCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.returnCode())
      .map(value => value: String)
    override val startTime: Timestamp =
      zio.aws.m2.model.primitives.Timestamp(impl.startTime())
    override val status: zio.aws.m2.model.BatchJobExecutionStatus =
      zio.aws.m2.model.BatchJobExecutionStatus.wrap(impl.status())
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetBatchJobExecutionResponse
  ): zio.aws.m2.model.GetBatchJobExecutionResponse.ReadOnly = new Wrapper(impl)
}
