package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.String200
import scala.jdk.CollectionConverters._
final case class FsxStorageConfiguration(
    fileSystemId: String200,
    mountPoint: String200
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.FsxStorageConfiguration = {
    import FsxStorageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.FsxStorageConfiguration
      .builder()
      .fileSystemId(String200.unwrap(fileSystemId): java.lang.String)
      .mountPoint(String200.unwrap(mountPoint): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.FsxStorageConfiguration.ReadOnly =
    zio.aws.m2.model.FsxStorageConfiguration.wrap(buildAwsValue())
}
object FsxStorageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.FsxStorageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.FsxStorageConfiguration =
      zio.aws.m2.model.FsxStorageConfiguration(fileSystemId, mountPoint)
    def fileSystemId: String200
    def mountPoint: String200
    def getFileSystemId: ZIO[Any, Nothing, String200] =
      ZIO.succeed(fileSystemId)
    def getMountPoint: ZIO[Any, Nothing, String200] = ZIO.succeed(mountPoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.FsxStorageConfiguration
  ) extends zio.aws.m2.model.FsxStorageConfiguration.ReadOnly {
    override val fileSystemId: String200 =
      zio.aws.m2.model.primitives.String200(impl.fileSystemId())
    override val mountPoint: String200 =
      zio.aws.m2.model.primitives.String200(impl.mountPoint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.FsxStorageConfiguration
  ): zio.aws.m2.model.FsxStorageConfiguration.ReadOnly = new Wrapper(impl)
}
