package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentResponse(environmentId: Identifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.UpdateEnvironmentResponse = {
    import UpdateEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.UpdateEnvironmentResponse
      .builder()
      .environmentId(Identifier.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.UpdateEnvironmentResponse.ReadOnly =
    zio.aws.m2.model.UpdateEnvironmentResponse.wrap(buildAwsValue())
}
object UpdateEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.UpdateEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.UpdateEnvironmentResponse =
      zio.aws.m2.model.UpdateEnvironmentResponse(environmentId)
    def environmentId: Identifier
    def getEnvironmentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.UpdateEnvironmentResponse
  ) extends zio.aws.m2.model.UpdateEnvironmentResponse.ReadOnly {
    override val environmentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.UpdateEnvironmentResponse
  ): zio.aws.m2.model.UpdateEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
