package zio.aws.m2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Version
import scala.jdk.CollectionConverters._
final case class UpdateApplicationResponse(applicationVersion: Version) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.UpdateApplicationResponse = {
    import UpdateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.UpdateApplicationResponse
      .builder()
      .applicationVersion(Version.unwrap(applicationVersion): Integer)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.UpdateApplicationResponse.ReadOnly =
    zio.aws.m2.model.UpdateApplicationResponse.wrap(buildAwsValue())
}
object UpdateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.UpdateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.UpdateApplicationResponse =
      zio.aws.m2.model.UpdateApplicationResponse(applicationVersion)
    def applicationVersion: Version
    def getApplicationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(applicationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.UpdateApplicationResponse
  ) extends zio.aws.m2.model.UpdateApplicationResponse.ReadOnly {
    override val applicationVersion: Version =
      zio.aws.m2.model.primitives.Version(impl.applicationVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.UpdateApplicationResponse
  ): zio.aws.m2.model.UpdateApplicationResponse.ReadOnly = new Wrapper(impl)
}
