package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListBatchJobExecutionsResponse(
    batchJobExecutions: Iterable[zio.aws.m2.model.BatchJobExecutionSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse = {
    import ListBatchJobExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse
      .builder()
      .batchJobExecutions(batchJobExecutions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListBatchJobExecutionsResponse.ReadOnly =
    zio.aws.m2.model.ListBatchJobExecutionsResponse.wrap(buildAwsValue())
}
object ListBatchJobExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListBatchJobExecutionsResponse =
      zio.aws.m2.model.ListBatchJobExecutionsResponse(
        batchJobExecutions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def batchJobExecutions
        : List[zio.aws.m2.model.BatchJobExecutionSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getBatchJobExecutions: ZIO[Any, Nothing, List[
      zio.aws.m2.model.BatchJobExecutionSummary.ReadOnly
    ]] = ZIO.succeed(batchJobExecutions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse
  ) extends zio.aws.m2.model.ListBatchJobExecutionsResponse.ReadOnly {
    override val batchJobExecutions
        : List[zio.aws.m2.model.BatchJobExecutionSummary.ReadOnly] = impl
      .batchJobExecutions()
      .asScala
      .map { item =>
        zio.aws.m2.model.BatchJobExecutionSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse
  ): zio.aws.m2.model.ListBatchJobExecutionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
