package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListApplicationsResponse(
    applications: Iterable[zio.aws.m2.model.ApplicationSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListApplicationsResponse
      .builder()
      .applications(applications.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListApplicationsResponse.ReadOnly =
    zio.aws.m2.model.ListApplicationsResponse.wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListApplicationsResponse =
      zio.aws.m2.model.ListApplicationsResponse(
        applications.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def applications: List[zio.aws.m2.model.ApplicationSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getApplications: ZIO[Any, Nothing, List[
      zio.aws.m2.model.ApplicationSummary.ReadOnly
    ]] = ZIO.succeed(applications)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListApplicationsResponse
  ) extends zio.aws.m2.model.ListApplicationsResponse.ReadOnly {
    override val applications
        : List[zio.aws.m2.model.ApplicationSummary.ReadOnly] = impl
      .applications()
      .asScala
      .map { item =>
        zio.aws.m2.model.ApplicationSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListApplicationsResponse
  ): zio.aws.m2.model.ListApplicationsResponse.ReadOnly = new Wrapper(impl)
}
