package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class DataSetImportTask(
    status: zio.aws.m2.model.DataSetTaskLifecycle,
    summary: zio.aws.m2.model.DataSetImportSummary,
    taskId: Identifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DataSetImportTask = {
    import DataSetImportTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DataSetImportTask
      .builder()
      .status(status.unwrap)
      .summary(summary.buildAwsValue())
      .taskId(Identifier.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DataSetImportTask.ReadOnly =
    zio.aws.m2.model.DataSetImportTask.wrap(buildAwsValue())
}
object DataSetImportTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.DataSetImportTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DataSetImportTask =
      zio.aws.m2.model.DataSetImportTask(status, summary.asEditable, taskId)
    def status: zio.aws.m2.model.DataSetTaskLifecycle
    def summary: zio.aws.m2.model.DataSetImportSummary.ReadOnly
    def taskId: Identifier
    def getStatus: ZIO[Any, Nothing, zio.aws.m2.model.DataSetTaskLifecycle] =
      ZIO.succeed(status)
    def getSummary
        : ZIO[Any, Nothing, zio.aws.m2.model.DataSetImportSummary.ReadOnly] =
      ZIO.succeed(summary)
    def getTaskId: ZIO[Any, Nothing, Identifier] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DataSetImportTask
  ) extends zio.aws.m2.model.DataSetImportTask.ReadOnly {
    override val status: zio.aws.m2.model.DataSetTaskLifecycle =
      zio.aws.m2.model.DataSetTaskLifecycle.wrap(impl.status())
    override val summary: zio.aws.m2.model.DataSetImportSummary.ReadOnly =
      zio.aws.m2.model.DataSetImportSummary.wrap(impl.summary())
    override val taskId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DataSetImportTask
  ): zio.aws.m2.model.DataSetImportTask.ReadOnly = new Wrapper(impl)
}
