package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DataSetImportItem(
    dataSet: zio.aws.m2.model.DataSet,
    externalLocation: zio.aws.m2.model.ExternalLocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DataSetImportItem = {
    import DataSetImportItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DataSetImportItem
      .builder()
      .dataSet(dataSet.buildAwsValue())
      .externalLocation(externalLocation.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DataSetImportItem.ReadOnly =
    zio.aws.m2.model.DataSetImportItem.wrap(buildAwsValue())
}
object DataSetImportItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.DataSetImportItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DataSetImportItem = zio.aws.m2.model
      .DataSetImportItem(dataSet.asEditable, externalLocation.asEditable)
    def dataSet: zio.aws.m2.model.DataSet.ReadOnly
    def externalLocation: zio.aws.m2.model.ExternalLocation.ReadOnly
    def getDataSet: ZIO[Any, Nothing, zio.aws.m2.model.DataSet.ReadOnly] =
      ZIO.succeed(dataSet)
    def getExternalLocation
        : ZIO[Any, Nothing, zio.aws.m2.model.ExternalLocation.ReadOnly] =
      ZIO.succeed(externalLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DataSetImportItem
  ) extends zio.aws.m2.model.DataSetImportItem.ReadOnly {
    override val dataSet: zio.aws.m2.model.DataSet.ReadOnly =
      zio.aws.m2.model.DataSet.wrap(impl.dataSet())
    override val externalLocation: zio.aws.m2.model.ExternalLocation.ReadOnly =
      zio.aws.m2.model.ExternalLocation.wrap(impl.externalLocation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DataSetImportItem
  ): zio.aws.m2.model.DataSetImportItem.ReadOnly = new Wrapper(impl)
}
