package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchJobIdentifier(
    fileBatchJobIdentifier: Optional[zio.aws.m2.model.FileBatchJobIdentifier] =
      Optional.Absent,
    scriptBatchJobIdentifier: Optional[
      zio.aws.m2.model.ScriptBatchJobIdentifier
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.BatchJobIdentifier = {
    import BatchJobIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.BatchJobIdentifier
      .builder()
      .optionallyWith(
        fileBatchJobIdentifier.map(value => value.buildAwsValue())
      )(_.fileBatchJobIdentifier)
      .optionallyWith(
        scriptBatchJobIdentifier.map(value => value.buildAwsValue())
      )(_.scriptBatchJobIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.BatchJobIdentifier.ReadOnly =
    zio.aws.m2.model.BatchJobIdentifier.wrap(buildAwsValue())
}
object BatchJobIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.BatchJobIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.BatchJobIdentifier =
      zio.aws.m2.model.BatchJobIdentifier(
        fileBatchJobIdentifier.map(value => value.asEditable),
        scriptBatchJobIdentifier.map(value => value.asEditable)
      )
    def fileBatchJobIdentifier
        : Optional[zio.aws.m2.model.FileBatchJobIdentifier.ReadOnly]
    def scriptBatchJobIdentifier
        : Optional[zio.aws.m2.model.ScriptBatchJobIdentifier.ReadOnly]
    def getFileBatchJobIdentifier
        : ZIO[Any, AwsError, zio.aws.m2.model.FileBatchJobIdentifier.ReadOnly] =
      AwsError.unwrapOptionField(
        "fileBatchJobIdentifier",
        fileBatchJobIdentifier
      )
    def getScriptBatchJobIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.m2.model.ScriptBatchJobIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scriptBatchJobIdentifier",
      scriptBatchJobIdentifier
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.BatchJobIdentifier
  ) extends zio.aws.m2.model.BatchJobIdentifier.ReadOnly {
    override val fileBatchJobIdentifier
        : Optional[zio.aws.m2.model.FileBatchJobIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileBatchJobIdentifier())
        .map(value => zio.aws.m2.model.FileBatchJobIdentifier.wrap(value))
    override val scriptBatchJobIdentifier
        : Optional[zio.aws.m2.model.ScriptBatchJobIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scriptBatchJobIdentifier())
        .map(value => zio.aws.m2.model.ScriptBatchJobIdentifier.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.BatchJobIdentifier
  ): zio.aws.m2.model.BatchJobIdentifier.ReadOnly = new Wrapper(impl)
}
