package zio.aws.m2.model
import zio.aws.m2.model.primitives.{
  String20,
  Identifier,
  EngineVersion,
  CapacityValue
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentRequest(
    applyDuringMaintenanceWindow: Optional[Boolean] = Optional.Absent,
    desiredCapacity: Optional[CapacityValue] = Optional.Absent,
    engineVersion: Optional[EngineVersion] = Optional.Absent,
    environmentId: Identifier,
    instanceType: Optional[String20] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.UpdateEnvironmentRequest = {
    import UpdateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.UpdateEnvironmentRequest
      .builder()
      .optionallyWith(
        applyDuringMaintenanceWindow.map(value => value: java.lang.Boolean)
      )(_.applyDuringMaintenanceWindow)
      .optionallyWith(
        desiredCapacity.map(value => CapacityValue.unwrap(value): Integer)
      )(_.desiredCapacity)
      .optionallyWith(
        engineVersion.map(value =>
          EngineVersion.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .environmentId(Identifier.unwrap(environmentId): java.lang.String)
      .optionallyWith(
        instanceType.map(value => String20.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.UpdateEnvironmentRequest.ReadOnly =
    zio.aws.m2.model.UpdateEnvironmentRequest.wrap(buildAwsValue())
}
object UpdateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.UpdateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.UpdateEnvironmentRequest =
      zio.aws.m2.model.UpdateEnvironmentRequest(
        applyDuringMaintenanceWindow.map(value => value),
        desiredCapacity.map(value => value),
        engineVersion.map(value => value),
        environmentId,
        instanceType.map(value => value),
        preferredMaintenanceWindow.map(value => value)
      )
    def applyDuringMaintenanceWindow: Optional[Boolean]
    def desiredCapacity: Optional[CapacityValue]
    def engineVersion: Optional[EngineVersion]
    def environmentId: Identifier
    def instanceType: Optional[String20]
    def preferredMaintenanceWindow: Optional[String]
    def getApplyDuringMaintenanceWindow: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "applyDuringMaintenanceWindow",
        applyDuringMaintenanceWindow
      )
    def getDesiredCapacity: ZIO[Any, AwsError, CapacityValue] =
      AwsError.unwrapOptionField("desiredCapacity", desiredCapacity)
    def getEngineVersion: ZIO[Any, AwsError, EngineVersion] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEnvironmentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(environmentId)
    def getInstanceType: ZIO[Any, AwsError, String20] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.UpdateEnvironmentRequest
  ) extends zio.aws.m2.model.UpdateEnvironmentRequest.ReadOnly {
    override val applyDuringMaintenanceWindow: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applyDuringMaintenanceWindow())
        .map(value => value: Boolean)
    override val desiredCapacity: Optional[CapacityValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredCapacity())
        .map(value => zio.aws.m2.model.primitives.CapacityValue(value))
    override val engineVersion: Optional[EngineVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.m2.model.primitives.EngineVersion(value))
    override val environmentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.environmentId())
    override val instanceType: Optional[String20] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.m2.model.primitives.String20(value))
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.UpdateEnvironmentRequest
  ): zio.aws.m2.model.UpdateEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
