package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ScriptBatchJobDefinition(scriptName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ScriptBatchJobDefinition = {
    import ScriptBatchJobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ScriptBatchJobDefinition
      .builder()
      .scriptName(scriptName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ScriptBatchJobDefinition.ReadOnly =
    zio.aws.m2.model.ScriptBatchJobDefinition.wrap(buildAwsValue())
}
object ScriptBatchJobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ScriptBatchJobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ScriptBatchJobDefinition =
      zio.aws.m2.model.ScriptBatchJobDefinition(scriptName)
    def scriptName: String
    def getScriptName: ZIO[Any, Nothing, String] = ZIO.succeed(scriptName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ScriptBatchJobDefinition
  ) extends zio.aws.m2.model.ScriptBatchJobDefinition.ReadOnly {
    override val scriptName: String = impl.scriptName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ScriptBatchJobDefinition
  ): zio.aws.m2.model.ScriptBatchJobDefinition.ReadOnly = new Wrapper(impl)
}
