package zio.aws.m2.model
import scala.jdk.CollectionConverters._
sealed trait EnvironmentLifecycle {
  def unwrap: software.amazon.awssdk.services.m2.model.EnvironmentLifecycle
}
object EnvironmentLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.m2.model.EnvironmentLifecycle
  ): zio.aws.m2.model.EnvironmentLifecycle = value match {
    case software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.AVAILABLE =>
      val r = Available
      r
    case software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.UPDATING =>
      val r = Updating
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.m2.model.EnvironmentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.EnvironmentLifecycle =
      software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating extends zio.aws.m2.model.EnvironmentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.EnvironmentLifecycle =
      software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.CREATING
  }
  case object Available extends zio.aws.m2.model.EnvironmentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.EnvironmentLifecycle =
      software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.AVAILABLE
  }
  case object Deleting extends zio.aws.m2.model.EnvironmentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.EnvironmentLifecycle =
      software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.DELETING
  }
  case object Failed extends zio.aws.m2.model.EnvironmentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.EnvironmentLifecycle =
      software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.FAILED
  }
  case object Updating extends zio.aws.m2.model.EnvironmentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.EnvironmentLifecycle =
      software.amazon.awssdk.services.m2.model.EnvironmentLifecycle.UPDATING
  }
}
