package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EngineVersionsSummary(
    engineType: String,
    engineVersion: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.EngineVersionsSummary = {
    import EngineVersionsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.EngineVersionsSummary
      .builder()
      .engineType(engineType: java.lang.String)
      .engineVersion(engineVersion: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.EngineVersionsSummary.ReadOnly =
    zio.aws.m2.model.EngineVersionsSummary.wrap(buildAwsValue())
}
object EngineVersionsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.EngineVersionsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.EngineVersionsSummary =
      zio.aws.m2.model.EngineVersionsSummary(engineType, engineVersion)
    def engineType: String
    def engineVersion: String
    def getEngineType: ZIO[Any, Nothing, String] = ZIO.succeed(engineType)
    def getEngineVersion: ZIO[Any, Nothing, String] = ZIO.succeed(engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.EngineVersionsSummary
  ) extends zio.aws.m2.model.EngineVersionsSummary.ReadOnly {
    override val engineType: String = impl.engineType(): String
    override val engineVersion: String = impl.engineVersion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.EngineVersionsSummary
  ): zio.aws.m2.model.EngineVersionsSummary.ReadOnly = new Wrapper(impl)
}
