package zio.aws.m2.model
import zio.aws.m2.model.primitives.Version
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DeployedVersionSummary(
    applicationVersion: Version,
    status: zio.aws.m2.model.DeploymentLifecycle,
    statusReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DeployedVersionSummary = {
    import DeployedVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DeployedVersionSummary
      .builder()
      .applicationVersion(Version.unwrap(applicationVersion): Integer)
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DeployedVersionSummary.ReadOnly =
    zio.aws.m2.model.DeployedVersionSummary.wrap(buildAwsValue())
}
object DeployedVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.DeployedVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DeployedVersionSummary =
      zio.aws.m2.model.DeployedVersionSummary(
        applicationVersion,
        status,
        statusReason.map(value => value)
      )
    def applicationVersion: Version
    def status: zio.aws.m2.model.DeploymentLifecycle
    def statusReason: Optional[String]
    def getApplicationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(applicationVersion)
    def getStatus: ZIO[Any, Nothing, zio.aws.m2.model.DeploymentLifecycle] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DeployedVersionSummary
  ) extends zio.aws.m2.model.DeployedVersionSummary.ReadOnly {
    override val applicationVersion: Version =
      zio.aws.m2.model.primitives.Version(impl.applicationVersion())
    override val status: zio.aws.m2.model.DeploymentLifecycle =
      zio.aws.m2.model.DeploymentLifecycle.wrap(impl.status())
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DeployedVersionSummary
  ): zio.aws.m2.model.DeployedVersionSummary.ReadOnly = new Wrapper(impl)
}
