package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class CreateDataSetImportTaskResponse(taskId: Identifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskResponse = {
    import CreateDataSetImportTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskResponse
      .builder()
      .taskId(Identifier.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.CreateDataSetImportTaskResponse.ReadOnly =
    zio.aws.m2.model.CreateDataSetImportTaskResponse.wrap(buildAwsValue())
}
object CreateDataSetImportTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.CreateDataSetImportTaskResponse =
      zio.aws.m2.model.CreateDataSetImportTaskResponse(taskId)
    def taskId: Identifier
    def getTaskId: ZIO[Any, Nothing, Identifier] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskResponse
  ) extends zio.aws.m2.model.CreateDataSetImportTaskResponse.ReadOnly {
    override val taskId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskResponse
  ): zio.aws.m2.model.CreateDataSetImportTaskResponse.ReadOnly = new Wrapper(
    impl
  )
}
