package zio.aws.m2.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationDeploymentLifecycle {
  def unwrap
      : software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle
}
object ApplicationDeploymentLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle
  ): zio.aws.m2.model.ApplicationDeploymentLifecycle = value match {
    case software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle.DEPLOYING =>
      val r = Deploying
      r
    case software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle.DEPLOYED =>
      val r = Deployed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.m2.model.ApplicationDeploymentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object Deploying
      extends zio.aws.m2.model.ApplicationDeploymentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle.DEPLOYING
  }
  case object Deployed extends zio.aws.m2.model.ApplicationDeploymentLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationDeploymentLifecycle.DEPLOYED
  }
}
